/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.BaseQuery;
import eu.europeana.downloads.OAIPMHQuery;
import eu.europeana.downloads.OAIPMHServiceClient;
import eu.europeana.downloads.SetsUtility;
import eu.europeana.downloads.ZipUtility;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CheckSumGenerator
extends BaseQuery
implements OAIPMHQuery {
    private static final Logger LOG = LogManager.getLogger(CheckSumGenerator.class);
    @Value(value="${sets-folder}")
    private String directoryLocation;
    @Value(value="#{'${zips-folder:${sets-folder:}}'}")
    private String zipsLocation;

    public String getVerbName() {
        return "CheckSum";
    }

    public void execute(OAIPMHServiceClient oaipmhServer, List<String> failedSets) {
        this.zipsLocation = this.zipsLocation.isEmpty() ? this.directoryLocation : this.zipsLocation;
        LOG.info("Generating CheckSum for the XML files ");
        this.generateCheckSum(SetsUtility.getFolderName((String)this.zipsLocation, (String)"XML"), SetsUtility.getFolderName((String)this.directoryLocation, (String)"XML"));
        LOG.info("Generating CheckSum for the TTL files ");
        this.generateCheckSum(SetsUtility.getFolderName((String)this.zipsLocation, (String)"TTL"), SetsUtility.getFolderName((String)this.directoryLocation, (String)"TTL"));
    }

    private void generateCheckSum(String zipsPath, String checkSumPath) {
        List zips = this.getZipFilesWithoutCheckSum(zipsPath);
        if (zips.isEmpty()) {
            LOG.info("No zips are present at location \"{}\" OR the \"{}\" directory does not exist.", (Object)zipsPath, (Object)zipsPath);
            LOG.info(" NO CheckSum are Generated");
        } else {
            LOG.info("Missing Checksum for Zips {} ", (Object)zips);
            for (String zipFile : zips) {
                LOG.info("Generating CheckSum for zip {} ", (Object)zipFile);
                String extension = "/" + zipFile;
                ZipUtility.createMD5SumFile((String)(zipsPath + extension), (String)(checkSumPath + extension));
            }
            LOG.info("Generated CheckSum for {} files ", (Object)zips.size());
        }
    }

    private List<String> getZipFiles(String location) {
        if (Files.exists(Paths.get(location, new String[0]), new LinkOption[0])) {
            return Stream.of(new File(location).listFiles()).filter(file -> file.getName().endsWith(".zip")).map(File::getName).collect(Collectors.toList());
        }
        LOG.error("NO such directory exists {}", (Object)location);
        return new ArrayList<String>();
    }

    private List<String> getZipFilesWithoutCheckSum(String location) {
        if (Files.exists(Paths.get(location, new String[0]), new LinkOption[0])) {
            ArrayList<String> zips = new ArrayList<String>();
            List<File> files = Arrays.asList(new File(location).listFiles());
            for (File file : files) {
                if (!file.getName().endsWith(".zip") || this.checksumExists(files, file.getName())) continue;
                zips.add(file.getName());
            }
            return zips;
        }
        LOG.error("NO such directory exists {}", (Object)location);
        return new ArrayList<String>();
    }

    private boolean checksumExists(List<File> fileList, String fileName) {
        for (File checksum : fileList) {
            if (!checksum.getName().endsWith(".md5sum") || !StringUtils.equalsIgnoreCase((CharSequence)checksum.getName(), (CharSequence)(fileName + ".md5sum"))) continue;
            return true;
        }
        return false;
    }
}

