/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.usermgt;

import eu.europeana.keycloak.SlackConnection;
import eu.europeana.keycloak.usermgt.UserDeleteTransaction;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.Provider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.utils.StringUtil;

@Provider
public class DeleteUnverifiedUserProvider
implements RealmResourceProvider {
    private static final Logger LOG = Logger.getLogger(DeleteUnverifiedUserProvider.class);
    private static final String LOG_PREFIX = "KEYCLOAK_EVENT:";
    private static final String SUCCESS_MSG = " unverified user accounts are scheduled for removal because their email addresses were not verified within ";
    private static final String DELETION_REPORT_MESSAGE = "{\"text\":\" %s unverified accounts were deleted.\"}";
    private static Map<String, String> emailNotVerified = new HashMap<String, String>();
    private static final Long MILLIS_PER_DAY;
    private KeycloakSession session;
    private RealmModel realm;
    private UserProvider userProvider;

    public DeleteUnverifiedUserProvider(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.userProvider = session.users();
    }

    public Object getResource() {
        return this;
    }

    @Path(value="")
    @GET
    @Produces(value={"application/json"})
    public String delete(@DefaultValue(value="1") @QueryParam(value="age") int minimumAgeInDays) {
        return this.removeUnverifiedUsers(minimumAgeInDays);
    }

    public void close() {
    }

    private String removeUnverifiedUsers(int minimumAgeInDays) {
        int nrOfDeletedUsers = 0;
        List<UserModel> unverifiedUsersToYesterday = this.getUnverifiedUsers(minimumAgeInDays);
        for (UserModel user : unverifiedUsersToYesterday) {
            UserDeleteTransaction userDeleteTransaction = new UserDeleteTransaction(this.userProvider, this.realm, user);
            this.session.getTransactionManager().enlistPrepare((KeycloakTransaction)userDeleteTransaction);
            LOG.info((Object)("#" + ++nrOfDeletedUsers + " - " + user.getUsername() + " scheduled for deletion"));
        }
        if (nrOfDeletedUsers > 0) {
            LOG.info((Object)(nrOfDeletedUsers + SUCCESS_MSG + minimumAgeInDays + " day(s)"));
        } else {
            LOG.info((Object)("No unverified users found in the realm " + String.valueOf(this.realm)));
        }
        SlackConnection conn = new SlackConnection("SLACK_WEBHOOK_DELETE_UNVERIFIED_USERS");
        conn.publishStatusReport(String.format(DELETION_REPORT_MESSAGE, nrOfDeletedUsers));
        return "Unverified user delete job finished.";
    }

    private List<UserModel> getUnverifiedUsers(int minimumAgeInDays) {
        return this.userProvider.searchForUserStream(this.realm, emailNotVerified).filter(u -> u.getCreatedTimestamp() < System.currentTimeMillis() - MILLIS_PER_DAY * (long)minimumAgeInDays).toList();
    }

    private String listUnverifiedUsers(int minimumAgeInDays) {
        List<UserModel> lazyUsers = this.getUnverifiedUsers(minimumAgeInDays);
        StringBuilder lazyList = new StringBuilder();
        int lazyCounter = 0;
        int lazySize = lazyUsers.size();
        if (lazySize == 0) {
            lazyList.append("Hurray, only motivated users today!");
        } else {
            if (lazySize == 1) {
                lazyList.append(lazySize);
                lazyList.append(" user ");
            } else {
                lazyList.append(lazySize);
                lazyList.append(" users ");
            }
            lazyList.append(" found the effort of validating their email address beyond their capabilities and were therefore asked to leave the premises. ");
            if (lazySize > 1) {
                lazyList.append("They are: ");
            } else {
                lazyList.append("He or she is: ");
            }
            for (UserModel lazyUser : lazyUsers) {
                ++lazyCounter;
                lazyList.append(lazyUser.getFirstName().charAt(0));
                lazyList.append(". ");
                lazyList.append(lazyUser.getLastName());
                if (lazySize == lazyCounter + 1) {
                    lazyList.append(" and ");
                    continue;
                }
                if (lazySize <= lazyCounter) continue;
                lazyList.append(", ");
            }
            lazyList.append(". (Disclaimer: this is just for testing and will be used only on the developer's own testing accounts. Invoking the privacy laws for communicating private data is therefore not required. Thank you.");
        }
        LOG.info((Object)lazyList.toString());
        return lazyList.toString();
    }

    private String logMessage(UserModel user, String message, int nrOfDeletedUsers) {
        StringBuilder msg = new StringBuilder();
        msg.append("type: UNVERIFIED_USER_DELETE");
        if (this.realm != null) {
            msg.append(", realm: ");
            msg.append(this.realm.getName());
        }
        if (user != null) {
            if (StringUtil.isNotBlank((String)user.getId())) {
                msg.append(", userId: ");
                msg.append(user.getId());
            }
            if (StringUtil.isNotBlank((String)user.getEmail())) {
                msg.append(", userEmail: ");
                msg.append(user.getEmail());
            }
            msg.append(", userName: ");
            msg.append(user.getUsername());
        }
        if (message != null) {
            msg.append(", message: ");
            msg.append((CharSequence)msg);
        }
        if (nrOfDeletedUsers > 0) {
            msg.append(". Number of users deleted: ");
            msg.append(nrOfDeletedUsers);
        }
        msg.append(" ");
        return LOG_PREFIX + String.valueOf(msg);
    }

    static {
        emailNotVerified.put("emailVerified", "false");
        emailNotVerified.put("keycloak.session.realm.users.query.include_service_account", "false");
        MILLIS_PER_DAY = 86400000L;
    }
}

