/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.usermgt;

import org.jboss.logging.Logger;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;

public class UserDeleteTransaction
extends AbstractKeycloakTransaction {
    private static final Logger LOG = Logger.getLogger(UserDeleteTransaction.class);
    private final UserProvider userProvider;
    private final UserModel user;
    private final RealmModel realm;

    public UserDeleteTransaction(UserProvider userProvider, RealmModel realm, UserModel user) {
        this.realm = realm;
        this.user = user;
        this.userProvider = userProvider;
    }

    protected void commitImpl() {
        try {
            boolean userRemoved = this.userProvider.removeUser(this.realm, this.user);
            if (userRemoved) {
                LOG.info((Object)(this.user.getUsername() + " | " + this.user.getEmail() + " removed"));
            } else {
                LOG.error((Object)(this.user.getUsername() + " | " + this.user.getEmail() + " NOT removed"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("## User delete transaction failed! ##", e);
        }
    }

    protected void rollbackImpl() {
    }
}

