/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.usermgt;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jboss.logging.Logger;

public class SlackConnection {
    private static final Logger LOG = Logger.getLogger(SlackConnection.class);
    private String slackWebhook;

    public SlackConnection(String slackWebhook) {
        this.slackWebhook = slackWebhook;
    }

    public void publishStatusReport(String message) {
        LOG.info((Object)("Sending Slack Message : " + message));
        try {
            String slackWebhookApiAutomation = System.getenv(this.slackWebhook);
            if (StringUtils.isBlank((CharSequence)slackWebhookApiAutomation)) {
                LOG.error((Object)"Slack webhook not configured, status report will not be published over Slack.");
                return;
            }
            HttpPost httpPost = new HttpPost(slackWebhookApiAutomation);
            httpPost.setEntity((HttpEntity)new StringEntity(message));
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                LOG.info((Object)("Received status " + response.getStatusLine().getStatusCode() + " while calling slack!"));
                if (response.getStatusLine().getStatusCode() == 200) {
                    LOG.info((Object)" Successfully sent slack message !");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Exception occurred while sending slack message !! " + e.getMessage()));
        }
    }
}

