/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.Token;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.web.email.EmailBuilder;
import eu.europeana.corelib.web.exception.EmailServiceException;
import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.service.EmailService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessagePreparator;

public abstract class EmailServiceImpl
implements EmailService {
    private static final Logger LOG = LogManager.getLogger(EmailServiceImpl.class);
    @Resource
    private JavaMailSenderImpl mailSender;

    @Override
    public void sendActivationToken(Token token, String apiHost) throws EmailServiceException {
        if (token == null || StringUtils.isBlank((String)token.getToken()) || StringUtils.isBlank((String)token.getEmail()) || StringUtils.isBlank((String)apiHost)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        String url = apiHost + "/user/activate/" + token.getEmail() + "/" + token.getToken();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", url);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("activation");
        builder.setEmailTo(token.getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        LOG.info("Sent token ({}) and URL ({}) to {}", new Object[]{token.getToken(), url, token.getEmail()});
    }

    @Override
    public void sendApiKeys(ApiKey apiKey) throws EmailServiceException {
        if (apiKey == null) {
            LOG.error("Problem with sendApiKeys: apiKey is null");
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("apiKey", apiKey);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("apikeys");
        builder.setEmailTo(apiKey.getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        LOG.info("Sent API details to {}", new Object[]{apiKey.getEmail()});
    }

    @Override
    public void sendNewPasswordToken(Token token, String apiHost, String salutation) throws EmailServiceException {
        if (token == null || StringUtils.isBlank((String)token.getToken()) || StringUtils.isBlank((String)token.getEmail()) || StringUtils.isBlank((String)apiHost)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        String url = apiHost + "/user/password/" + token.getEmail() + "/" + token.getToken();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", url);
        model.put("salutation", salutation);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("forgotPassword");
        builder.setEmailTo(token.getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        LOG.info("Sent password reset url ({}) to {}", new Object[]{url, token.getEmail()});
    }

    @Override
    public void sendPasswordResetConfirmation(User user, String salutation) throws EmailServiceException {
        if (user == null || user.getId() == null) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("salutation", salutation);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("resetPasswordConfirm");
        builder.setEmailTo(user.getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        LOG.info("Sent password reset confirmation email to ({})", new Object[]{user.getEmail()});
    }

    @Override
    public void sendForgotPassword(User user, String url) throws EmailServiceException {
        if (user == null || user.getId() == null || StringUtils.isBlank((String)url)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        this.sendForgotPassword(user.getEmail(), url);
    }

    @Override
    public void sendForgotPassword(String email, String url) throws EmailServiceException {
        if (StringUtils.isBlank((String)email) || StringUtils.isBlank((String)url)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", url);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("forgotPassword");
        builder.setEmailTo(email);
        this.mailSender.send((MimeMessagePreparator)builder);
        LOG.info("Sent forgot password (URL={}) to {}", new Object[]{url, email});
    }

    @Override
    public void sendFeedback(String email, String feedback) throws EmailServiceException {
        if (StringUtils.isBlank((String)email) || StringUtils.isBlank((String)feedback)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("email", email);
        model.put("feedback", feedback);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("userFeedback");
        this.mailSender.send((MimeMessagePreparator)builder);
        builder.setTemplate("userFeedbackConfirm");
        builder.setEmailTo(email);
        this.mailSender.send((MimeMessagePreparator)builder);
        LOG.info("Sent feedback of {}", new Object[]{email});
    }

    @Override
    public void sendException(String subject, String body) throws EmailServiceException {
        if (StringUtils.isBlank((String)subject) || StringUtils.isBlank((String)body)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subject", subject);
        model.put("body", body);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("exception");
        builder.setSubject(subject);
        this.mailSender.send((MimeMessagePreparator)builder);
    }

    protected abstract EmailBuilder createEmailBuilder();
}

