/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.context;

import eu.europeana.corelib.web.socks.SocksProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudFoundryVcapEnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.support.StandardServletEnvironment;

public class VcapPropertyLoader
extends CloudFoundryVcapEnvironmentPostProcessor {
    private static final Logger LOG = LogManager.getLogger((String)VcapPropertyLoader.class.getName());
    private static final String VCAP = "vcap.services.";
    private static final String USERNAME = ".credentials.username";
    private static final String HOSTS = ".credentials.hosts";
    private static final String PASSWORD = ".credentials.password";
    private static final String POSTGRESDB = "vcap.services.";
    private static final String CREDENTIALS_DB = ".credentials.db";
    private static final String POSTGRESUSERNAME = "vcap.services.";
    private static final String CREDENTIALS_USER = ".credentials.user";
    private static final String POSTGRESPASSWORD = "vcap.services.";
    private static final String CREDENTIALS_PASSWORD = ".credentials.password";
    private static final String POSTGRESHOST = "vcap.services.";
    private static final String CREDENTIALS_HOST = ".credentials.host";
    private static final String VCAP_API2_BASEURL = "api2_baseUrl";
    private static final String VCAP_PORTAL_BASEURL = "portal_baseUrl";
    private static final String POSTGRES = "postgres";
    private static StandardServletEnvironment env = new StandardServletEnvironment();

    public VcapPropertyLoader() {
        this.postProcessEnvironment((ConfigurableEnvironment)env, new SpringApplication(new Object[0]));
        ClassLoader c = ((Object)((Object)this)).getClass().getClassLoader();
        URLClassLoader urlC = (URLClassLoader)c;
        URL[] urls = urlC.getURLs();
        String path = urls[0].getPath();
        Properties props = new Properties();
        File europeanaProperties = new File(path + "/europeana.properties");
        try (FileInputStream fis = new FileInputStream(europeanaProperties);){
            props.load(fis);
            if (env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_HOST) != null) {
                props.setProperty("postgres.db", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_DB));
                props.setProperty("postgres.username", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_USER));
                props.setProperty("postgres.password", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + ".credentials.password"));
                props.setProperty("postgres.host", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_HOST));
            }
            this.setVcapUrlProperty(props, VCAP_API2_BASEURL);
            this.setVcapUrlProperty(props, VCAP_PORTAL_BASEURL);
            ArrayList<String> sortedKeys = new ArrayList<String>();
            for (Object object : props.keySet()) {
                sortedKeys.add(object.toString());
            }
            Collections.sort(sortedKeys);
            StringBuilder sb = new StringBuilder();
            sb.append("#Generated by the VCAPPropertyLoaderListener\n");
            sb.append("#").append(new Date().toString()).append("\n");
            for (String key : sortedKeys) {
                sb.append(key).append("=").append(props.getProperty(key)).append("\n");
            }
            FileUtils.writeStringToFile((File)europeanaProperties, (String)(sb + "\n"), (boolean)false);
            LOG.info("Properties: {}", new Object[]{sb.toString()});
            String string = props.getProperty("socks.host");
            Boolean enabled = Boolean.valueOf(props.getProperty("socks.enabled"));
            if (StringUtils.isEmpty((String)string)) {
                LOG.info("No socks proxy host configured");
            } else if (!enabled.booleanValue()) {
                LOG.info("Socks proxy disabled");
            } else {
                LOG.info("Setting up proxy at " + string);
                this.initSocksProxyConfig(string, props.getProperty("socks.port"), props.getProperty("socks.user"), props.getProperty("socks.password"));
            }
        }
        catch (IOException e) {
            LOG.error("Error reading properties", (Throwable)e);
        }
    }

    private void setVcapUrlProperty(Properties props, String vcapKey) {
        String value = (String)env.getSystemEnvironment().get(vcapKey);
        if (StringUtils.isNotBlank((String)value)) {
            String propKey = StringUtils.replaceChars((String)vcapKey, (String)"_", (String)".");
            if (!StringUtils.startsWithIgnoreCase((String)value, (String)"http")) {
                value = "https://" + value;
            }
            LOG.info("VCAP Url property {} with is added to application properties as {}. Value = {}", new Object[]{vcapKey, propKey, value});
            props.setProperty(propKey, value);
        }
    }

    private void initSocksProxyConfig(String host, String port, String user, String password) {
        SocksProxy socksProxy = new SocksProxy(host, port, user, password);
        socksProxy.init();
    }
}

