/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.socks;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Base64;
import org.apache.commons.lang.StringUtils;

public class SocksProxy
extends Authenticator {
    private ProxyAuthenticator auth;
    private String host;
    private String port;
    private String user;
    private String password;

    public SocksProxy(String host, String port, String user, String password) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public void init() {
        System.setProperty("socksProxyHost", this.host);
        System.setProperty("socksProxyPort", this.port);
        if (StringUtils.isNotEmpty((String)this.user)) {
            System.setProperty("java.net.socks.username", this.user);
            System.setProperty("java.net.socks.password", this.password);
            this.auth = new ProxyAuthenticator(this.user, this.password);
            Authenticator.setDefault(this.auth);
        }
    }

    public String getEncodedAuth() {
        return Base64.getEncoder().encodeToString((this.auth.user + ":" + this.auth.password).getBytes());
    }

    public ProxyAuthenticator getAuth() {
        return this.auth;
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private String user;
        private String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

