/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import eu.europeana.corelib.web.model.ApiResult;
import eu.europeana.corelib.web.model.ApiResultImpl;
import eu.europeana.corelib.web.service.JsonApiService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonApiServiceImpl
implements JsonApiService {
    private static final String USER_AGENT = "Europeana API-bot/2.0 (Europeana; http://europeana.eu; api@europeana.eu)";
    private static final Logger LOG = LogManager.getLogger(JsonApiServiceImpl.class);
    private String lastUrl;

    @Override
    public ApiResult getJsonResponse(String url) {
        this.lastUrl = url;
        ApiResultImpl result = new ApiResultImpl();
        try {
            Header[] headers;
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            method.setRequestHeader("User-Agent", USER_AGENT);
            result.setHttpStatusCode(client.executeMethod((HttpMethod)method));
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)method.getResponseBodyAsStream(), (Writer)writer, (String)"UTF-8");
            result.setContent(writer.toString());
            ArrayList<String> requestHeaders = new ArrayList<String>();
            requestHeaders.add(String.format("%s %s %s", method.getName(), method.getPath(), method.getEffectiveVersion()));
            for (Header header : headers = method.getRequestHeaders()) {
                requestHeaders.add(String.format("%s: %s", header.getName(), header.getValue()));
            }
            result.setRequestHeaders(requestHeaders);
            ArrayList<String> responseHeaders = new ArrayList<String>();
            responseHeaders.add(method.getStatusLine().toString());
            for (Header header : headers = method.getResponseHeaders()) {
                responseHeaders.add(String.format("%s: %s", header.getName(), header.getValue()));
            }
            result.setResponseHeaders(responseHeaders);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getLastUrl() {
        return this.lastUrl;
    }
}

