/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import eu.europeana.corelib.definitions.ApplicationContextContainer;
import eu.europeana.corelib.definitions.model.ThumbSize;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import eu.europeana.corelib.web.support.Configuration;
import eu.europeana.corelib.web.utils.UrlBuilder;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class EuropeanaUrlServiceImpl
implements EuropeanaUrlService {
    @Resource
    private Configuration configuration;

    public static EuropeanaUrlService getBeanInstance() {
        return (EuropeanaUrlService)ApplicationContextContainer.getBean(EuropeanaUrlServiceImpl.class);
    }

    @Override
    public UrlBuilder getApi1Home(String apikey) {
        UrlBuilder url = new UrlBuilder(this.configuration.getApi2url());
        url.addPath("v1");
        url.addParam("wskey", apikey, true);
        return url;
    }

    @Override
    public UrlBuilder getApi2Home(String apikey) {
        UrlBuilder url = new UrlBuilder(this.configuration.getApi2url());
        url.addPath("v2");
        url.addParam("wskey", apikey, true);
        return url;
    }

    @Override
    public UrlBuilder getApi1SearchJson(String apikey, String query, int start) throws UnsupportedEncodingException {
        UrlBuilder url = this.getApi1Home(apikey);
        url.addPage("search.json");
        url.addParam("searchTerms", query, true);
        url.addParam("startPage", start);
        return url;
    }

    @Override
    public UrlBuilder getApi2SearchJson(String apikey, String query, String rows) throws UnsupportedEncodingException {
        UrlBuilder url = this.getApi2Home(apikey);
        url.addPage("search.json");
        url.addParam("query", query);
        url.addParam("rows", rows);
        return url;
    }

    @Override
    public UrlBuilder getApi2RecordJson(String apikey, String collectionid, String objectid) {
        UrlBuilder url = this.getApi2Home(apikey);
        url.addPath("record", collectionid).addPage(objectid + ".json");
        return url;
    }

    @Override
    public UrlBuilder getApi2RecordJson(String apikey, String europeanaId) {
        return this.getApi2Record(apikey, europeanaId, ".json");
    }

    @Override
    public UrlBuilder getApi1Record(String apikey, String europeanaId, String extention) {
        UrlBuilder url = this.getApi1Home(apikey);
        url.addPath("record").addPage(europeanaId + extention);
        return url;
    }

    @Override
    public UrlBuilder getApi2Record(String apikey, String europeanaId, String extention) {
        UrlBuilder url = this.getApi2Home(apikey);
        url.addPath("record").addPage(europeanaId + extention);
        return url;
    }

    @Override
    public UrlBuilder getApi2Redirect(String apikey, String shownAt, String provider, String europeanaId, String profile) {
        UrlBuilder url = new UrlBuilder(this.configuration.getApi2url());
        url.addPath(String.valueOf(apikey), "redirect").disableTrailingSlash();
        url.addParam("shownAt", shownAt);
        url.addParam("provider", provider);
        url.addParam("id", this.getPortalResolve(europeanaId));
        url.addParam("profile", profile);
        return url;
    }

    @Override
    public UrlBuilder getPortalHome(boolean relative) {
        UrlBuilder url = relative ? new UrlBuilder("") : new UrlBuilder(this.configuration.getPortalServer());
        return url;
    }

    @Override
    public String getPortalResolve(String europeanaId) {
        UrlBuilder url = new UrlBuilder("http://www.europeana.eu");
        url.addPath("resolve", "record", europeanaId).disableTrailingSlash();
        return url.toString();
    }

    @Override
    public String getPortalResolve(String collectionid, String objectid) {
        UrlBuilder url = new UrlBuilder("http://www.europeana.eu");
        url.addPath("resolve", "record", collectionid, objectid).disableTrailingSlash();
        return url.toString();
    }

    @Override
    public UrlBuilder getPortalSearch() throws UnsupportedEncodingException {
        return this.getPortalSearch(true, "search.html", null, null);
    }

    @Override
    public UrlBuilder getPortalSearch(boolean relative, String query, String rows) throws UnsupportedEncodingException {
        return this.getPortalSearch(relative, "search.html", query, rows);
    }

    @Override
    public UrlBuilder getPortalSearch(boolean relative, String searchpage, String query, String rows) throws UnsupportedEncodingException {
        UrlBuilder url = this.getPortalHome(relative);
        url.addPage(searchpage);
        url.addParam("query", query, true);
        url.addParam("rows", rows, true);
        return url;
    }

    @Override
    public UrlBuilder getPortalRecord(boolean relative, String collectionid, String objectid) {
        UrlBuilder url = this.getPortalHome(relative);
        url.addPath("record", collectionid).addPage(objectid + ".html");
        return url;
    }

    @Override
    public UrlBuilder getPortalRecord(boolean relative, String europeanaId) {
        UrlBuilder url = this.getPortalHome(relative);
        url.addPath("record").addPage(europeanaId + ".html");
        return url;
    }

    @Override
    public UrlBuilder getCanonicalPortalRecord(String europeanaId) {
        UrlBuilder url = new UrlBuilder("http://www.europeana.eu");
        url.addPath("record").addPage(europeanaId + ".html");
        return url;
    }

    @Override
    public UrlBuilder getThumbnailUrl(String thumbnail, DocType type) {
        if (null == this.configuration.getImageCacheUrl()) {
            return new UrlBuilder("");
        }
        UrlBuilder url = new UrlBuilder(this.configuration.getImageCacheUrl());
        if (thumbnail != null) {
            url.addParam("uri", thumbnail.trim());
        }
        url.addParam("size", ThumbSize.LARGE.toString());
        if (type != null) {
            url.addParam("type", type.toString());
        }
        return url;
    }

    @Override
    public String extractEuropeanaId(String url) {
        if (StringUtils.contains((String)url, (String)"record")) {
            url = StringUtils.removeEnd((String)url, (String)".html");
            String recordId = StringUtils.substringAfterLast((String)url, (String)"/");
            url = StringUtils.substringBeforeLast((String)url, (String)"/");
            String collectionId = StringUtils.substringAfterLast((String)url, (String)"/");
            return EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId);
        }
        return null;
    }
}

