/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.context;

import eu.europeana.corelib.web.socks.SocksProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloudfoundry.VcapApplicationListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.support.StandardServletEnvironment;

public class VcapPropertyLoaderListener
extends VcapApplicationListener {
    private static final Logger LOG = Logger.getLogger(VcapPropertyLoaderListener.class.getName());
    private static final String VCAP = "vcap.services.";
    private static final String USERNAME = ".credentials.username";
    private static final String HOSTS = ".credentials.hosts";
    private static final String PASSWORD = ".credentials.password";
    private static final String POSTGRESDB = "vcap.services.";
    private static final String CREDENTIALS_DB = ".credentials.db";
    private static final String POSTGRESUSERNAME = "vcap.services.";
    private static final String CREDENTIALS_USER = ".credentials.user";
    private static final String POSTGRESPASSWORD = "vcap.services.";
    private static final String CREDENTIALS_PASSWORD = ".credentials.password";
    private static final String POSTGRESHOST = "vcap.services.";
    private static final String CREDENTIALS_HOST = ".credentials.host";
    private static final String MONGO_SERVICE = "mongo_service";
    private static final String MONGO_DBNAME = "mongodb.dbname";
    private static final String MONGO_DBNAME_VALUE = "europeana";
    private static final String REDISHOST = "vcap.services.redis.credentials.host";
    private static final String REDISPORT = "vcap.services.redis.credentials.port";
    private static final String REDISPASSWORD = "vcap.services.redis.credentials.password";
    private static String HTTP = "http://";
    private static final String API2URL = "api2_url";
    private static final String API2CANONICALURL = "api2_canonical_url";
    private static final String PORTALSERVER = "portal_server";
    private static final String PORTALCANONICALURL = "portal_server_canonical";
    private static final String POSTGRES = "postgres";
    private static StandardServletEnvironment env = new StandardServletEnvironment();

    public VcapPropertyLoaderListener() {
        this.onApplicationEvent(new ApplicationEnvironmentPreparedEvent(new SpringApplication(new Object[0]), new String[0], (ConfigurableEnvironment)env));
        ClassLoader c = ((Object)((Object)this)).getClass().getClassLoader();
        URLClassLoader urlC = (URLClassLoader)c;
        URL[] urls = urlC.getURLs();
        String path = urls[0].getPath();
        Properties props = new Properties();
        File europeanaProperties = new File(path + "/europeana.properties");
        try (FileInputStream fis = new FileInputStream(europeanaProperties);){
            props.load(fis);
            if (env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_HOST) != null) {
                props.setProperty("postgres.db", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_DB));
                props.setProperty("postgres.username", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_USER));
                props.setProperty("postgres.password", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + ".credentials.password"));
                props.setProperty("postgres.host", env.getProperty("vcap.services." + env.getProperty(POSTGRES) + CREDENTIALS_HOST));
            }
            if (env.getSystemEnvironment().containsKey(MONGO_SERVICE)) {
                String mongoDb = env.getSystemEnvironment().get(MONGO_SERVICE).toString();
                String mongoUserName = "vcap.services." + mongoDb + USERNAME;
                String mongoPassword = "vcap.services." + mongoDb + ".credentials.password";
                String mongoHosts = "vcap.services." + mongoDb + HOSTS;
                props.setProperty("mongodb.username", env.getProperty(mongoUserName));
                props.setProperty("mongodb.password", env.getProperty(mongoPassword));
                props.setProperty("metainfo.mongodb.username", env.getProperty(mongoUserName));
                props.setProperty("metainfo.mongodb.password", env.getProperty(mongoPassword));
                String[] hosts = env.getProperty(mongoHosts).replace('[', ' ').replace("]", " ").split(",");
                String mongoHost = "";
                String mongoPort = "";
                for (String host : hosts) {
                    mongoHost = mongoHost + host.split(":")[0].trim() + ",";
                    mongoPort = mongoPort + host.split(":")[1].trim() + ",";
                }
                props.setProperty("mongodb.host", mongoHost.substring(0, mongoHost.length() - 1));
                props.setProperty("mongodb.port", mongoPort.substring(0, mongoPort.length() - 1));
                props.setProperty("metainfo.mongodb.host", mongoHost.substring(0, mongoHost.length() - 1));
                props.setProperty("metainfo.mongodb.port", mongoPort.substring(0, mongoPort.length() - 1));
                props.setProperty(MONGO_DBNAME, MONGO_DBNAME_VALUE);
            }
            if (env.getProperty(REDISHOST) != null) {
                props.setProperty("redis.host", env.getProperty(REDISHOST));
                props.setProperty("redis.port", env.getProperty(REDISPORT));
                props.setProperty("redis.password", env.getProperty(REDISPASSWORD));
            }
            this.setHTTPProperty(props, API2URL);
            this.setHTTPProperty(props, API2CANONICALURL);
            this.setHTTPProperty(props, PORTALCANONICALURL);
            this.setHTTPProperty(props, PORTALSERVER);
            ArrayList<String> sortedKeys = new ArrayList<String>();
            for (Object key : props.keySet()) {
                sortedKeys.add(key.toString());
            }
            Collections.sort(sortedKeys);
            StringBuilder sb = new StringBuilder();
            sb.append("#Generated by the VCAPPropertyLoaderListener\n");
            sb.append("#").append(new Date().toString()).append("\n");
            for (String key : sortedKeys) {
                sb.append(key).append("=").append(props.getProperty(key)).append("\n");
            }
            FileUtils.writeStringToFile((File)europeanaProperties, (String)(sb + "\n"), (boolean)false);
            LOG.log(Level.INFO, "Properties:\n" + sb.toString());
            String host = props.getProperty("socks.host");
            Boolean enabled = Boolean.valueOf(props.getProperty("socks.enabled"));
            if (StringUtils.isEmpty((String)host)) {
                LOG.log(Level.INFO, "No socks proxy host configured");
            } else if (enabled == null || !enabled.booleanValue()) {
                LOG.log(Level.INFO, "Socks proxy disabled");
            } else {
                LOG.log(Level.INFO, "Setting up proxy at " + host);
                this.initSocksProxyConfig(host, props.getProperty("socks.port"), props.getProperty("socks.user"), props.getProperty("socks.password"));
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error reading properties", e);
        }
    }

    private void setHTTPProperty(Properties props, String key) throws IOException {
        if (env.containsProperty(key)) {
            props.setProperty(StringUtils.replaceChars((String)key, (String)"_", (String)"."), HTTP + env.getSystemEnvironment().get(key));
        }
    }

    private void initSocksProxyConfig(String host, String port, String user, String password) {
        SocksProxy socksProxy = new SocksProxy(host, port, user, password);
        socksProxy.init();
    }
}

