/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.exception;

import eu.europeana.corelib.web.exception.ProblemResponseAction;

public enum ProblemType {
    NOT_FOUND("Entity doesn't exists", ProblemResponseAction.IGNORE),
    MATCH_ALL_DOCS("org.apache.lucene.search.MatchAllDocsQuery", ProblemResponseAction.IGNORE),
    UNDEFINED_FIELD("Undefined field", ProblemResponseAction.IGNORE),
    RECORD_NOT_INDEXED("Requested Europeana record not indexed.", ProblemResponseAction.IGNORE),
    RECORD_NOT_FOUND("Requested Europeana record not found.", ProblemResponseAction.IGNORE),
    PAGE_NOT_FOUND("Requested Europeana page not found.", ProblemResponseAction.IGNORE),
    RECORD_REVOKED("Europeana record is revoked by the content provider.", ProblemResponseAction.IGNORE),
    MALFORMED_URL("Required parameters are missing from the request.", ProblemResponseAction.LOG),
    MALFORMED_QUERY("Invalid query parameter.", ProblemResponseAction.LOG),
    UNKNOWN("unknown", ProblemResponseAction.IGNORE),
    UNABLE_TO_CHANGE_LANGUAGE("We are unable to change the interface to the requested language.", ProblemResponseAction.LOG),
    TOKEN_INVALID("Europeana token has expired and is no longer valid.", ProblemResponseAction.IGNORE),
    TOKEN_EXPIRED("Europeana token has expired and is no longer valid.", ProblemResponseAction.IGNORE),
    TOKEN_MISMATCH("This Europeana token is not associated with the supplied email address.", ProblemResponseAction.LOG),
    UNKNOWN_TOKEN("Token does not exist.", ProblemResponseAction.IGNORE),
    TOKEN_OUTDATED("Token is outdated.", ProblemResponseAction.IGNORE),
    SOLR_UNREACHABLE("Unable to reach Solr Search Engine (Europeana Exception).", ProblemResponseAction.MAIL),
    UNABLE_TO_PARSE_CURSORMARK("The provided cursor value is invalid, please make sure you encode the value before passing back on to the API.", ProblemResponseAction.LOG),
    UNABLE_TO_PARSE_JSON("Unable to parse JSON response.", ProblemResponseAction.LOG),
    MALFORMED_SPRING_TYPE_CONVERSION("org.springframework.beans.TypeMismatchException:", ProblemResponseAction.IGNORE),
    NONE("An exception occurred", ProblemResponseAction.MAIL),
    INCONSISTENT_DATA("Inconsistent data", ProblemResponseAction.MAIL),
    INVALIDARGUMENTS("Service is called with invalid argument(s)", ProblemResponseAction.MAIL),
    INVALIDCLASS("Service is called with invalid bean class.", ProblemResponseAction.MAIL),
    UNKNOWN_MONGO_DB_HOST("Unknown MongoDB host", ProblemResponseAction.MAIL),
    MONGO_UNREACHABLE("Cannot connect to MongoDB host", ProblemResponseAction.MAIL),
    NEO4J_CANNOTGETNODE("Cannot retrieve hierarchical node", ProblemResponseAction.LOG),
    NEO4J_INCONSISTENT_DATA("Inconsistency detected in hierarchical data", ProblemResponseAction.MAIL),
    XMPMETADATACREATION("Unable to crate XMP metadata for thumbnail", ProblemResponseAction.IGNORE),
    XMPMETADATARETRIEVAL("Error while reading XMP metadata from thumbnail", ProblemResponseAction.IGNORE),
    NO_USERNAME("User name does not exist.", ProblemResponseAction.IGNORE),
    NO_PASSWORD("Password does not exist.", ProblemResponseAction.IGNORE),
    NO_OLD_PASSWORD("Old password does not exist.", ProblemResponseAction.IGNORE),
    NO_USER_ID("User id does not exist.", ProblemResponseAction.IGNORE),
    NO_USER("User does not exist.", ProblemResponseAction.IGNORE),
    MISSING_PARAM_USERNAME("Required parameter 'username' missing.", ProblemResponseAction.IGNORE),
    MISSING_PARAM_EMAIL("Required parameter 'email' missing.", ProblemResponseAction.IGNORE),
    MISSING_PARAM_PASSWORD("Required parameter 'password' missing.", ProblemResponseAction.IGNORE),
    DUPLICATE("Record already exists.", ProblemResponseAction.IGNORE),
    RECORD_RETRIEVAL_ERROR("Record retrieval error", ProblemResponseAction.LOG),
    INVALID_URL("Url is invalid", ProblemResponseAction.LOG),
    SEARCH_LIMIT_REACHED("Sorry! It is not possible to paginate beyond the first 1000 search results. Please use the cursor-based pagination to paginate beyond the first 1000 search results.", ProblemResponseAction.LOG);

    private String message;
    private ProblemResponseAction action;

    private ProblemType(String message, ProblemResponseAction action) {
        this.message = message;
        this.action = action;
    }

    public static ProblemType get(String message) {
        for (ProblemType problem : ProblemType.values()) {
            if (!message.toLowerCase().startsWith(problem.toString().toLowerCase())) continue;
            return problem;
        }
        return UNKNOWN;
    }

    public String getMessage() {
        return this.message;
    }

    public ProblemResponseAction getAction() {
        return this.action;
    }
}

