/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.interceptor;

import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.exception.WebConfigurationException;
import eu.europeana.corelib.web.model.PageData;
import eu.europeana.corelib.web.support.Configuration;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ConfigInterceptor
extends HandlerInterceptorAdapter {
    private final Logger log = Logger.getLogger(ConfigInterceptor.class);
    @Resource
    private Configuration config;
    @Value(value="#{europeanaProperties['portal.bing.translate.key']}")
    private String portalBingTranslateId;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, o, modelAndView);
        if (modelAndView != null && !modelAndView.getViewName().startsWith("redirect:") && modelAndView.getModel().containsKey("model")) {
            PageData model = (PageData)modelAndView.getModel().get("model");
            StringBuilder currentUrl = new StringBuilder(this.config.getPortalServer());
            currentUrl.append(request.getRequestURI());
            if (request.getQueryString() != null) {
                currentUrl.append("?").append(request.getQueryString());
            }
            model.setPortalServer(this.checkMandatoryValue(this.config.getPortalServer(), "portal.server"));
            model.setBingTranslateId(StringUtils.trimToEmpty((String)this.portalBingTranslateId));
        }
    }

    private String checkMandatoryValue(String value, String name) throws WebConfigurationException {
        if (StringUtils.isBlank((String)value)) {
            ProblemType problem = ProblemType.INVALIDARGUMENTS;
            String message = null;
            if (StringUtils.isNotBlank((String)name)) {
                message = "Inexisting property: " + name;
                this.log.error((Object)message);
            }
            throw new WebConfigurationException(problem, message);
        }
        return StringUtils.trim((String)value);
    }
}

