/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.utils;

import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.web.exception.InvalidUrlException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.log4j.Logger;

public class UrlBuilder {
    private static Logger log = Logger.getLogger(UrlBuilder.class);
    public static final String PATH_SEPERATOR = "/";
    private String protocol = "http";
    private String domain = null;
    private int port = 80;
    private StringBuilder path;
    private String anchor = null;
    private boolean disableProtocol = false;
    private boolean disableDomain = false;
    private boolean trailingSlash = false;
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private Map<String, List<String>> multiParams = new LinkedHashMap<String, List<String>>();

    public UrlBuilder(String url) {
        this.setBaseUrl(StringUtils.replace((String)url, (String)"&amp;", (String)"&"));
    }

    private void setBaseUrl(String url) {
        if (StringUtils.isBlank((String)(url = StringUtils.stripEnd((String)url, (String)"/?&"))) || StringUtils.startsWith((String)url, (String)PATH_SEPERATOR)) {
            this.disableDomain = true;
        } else {
            if (StringUtils.contains((String)url, (String)"://")) {
                this.protocol = StringUtils.substringBefore((String)url, (String)"://");
                url = StringUtils.substringAfter((String)url, (String)"://");
            }
            this.domain = StringUtils.substringBefore((String)url, (String)PATH_SEPERATOR);
            if (!StringUtils.contains((String)this.domain, (String)":")) {
                url = StringUtils.substringAfter((String)url, (String)this.domain);
            } else {
                this.port = NumberUtils.toInt((String)StringUtils.substringAfter((String)this.domain, (String)":"));
                this.domain = StringUtils.substringBefore((String)this.domain, (String)":");
                url = StringUtils.substringAfter((String)url, (String)(":" + this.port));
            }
        }
        if (StringUtils.contains((String)url, (String)"#")) {
            this.anchor = StringUtils.substringAfterLast((String)url, (String)"#");
            url = StringUtils.substringBeforeLast((String)url, (String)"#");
        }
        if (StringUtils.contains((String)url, (char)'?')) {
            url = this.stripBaseUrl(url);
        }
        this.path = new StringBuilder(StringUtils.replace((String)url, (String)"//", (String)PATH_SEPERATOR));
    }

    private String stripBaseUrl(String url) {
        String stripped;
        String[] result = StringUtils.split((String)url, (char)'?');
        String toProcess = null;
        if (result.length == 2) {
            stripped = result[0];
            toProcess = result[1];
        } else if (StringUtils.endsWith((String)url, (String)"?")) {
            stripped = result[0];
        } else {
            stripped = "";
            toProcess = result[0];
        }
        this.addParamsFromURL(toProcess, new String[0]);
        return stripped;
    }

    public UrlBuilder disableProtocol() {
        this.disableProtocol = true;
        return this;
    }

    public UrlBuilder disableDomain() {
        this.disableDomain = true;
        return this;
    }

    public UrlBuilder disableTrailingSlash() {
        this.trailingSlash = false;
        return this;
    }

    public UrlBuilder setAnchor(String a) {
        this.anchor = a;
        return this;
    }

    public UrlBuilder addPath(String ... paths) {
        if (StringArrayUtils.isNotBlank((String[])paths)) {
            for (String p : paths) {
                p = StringUtils.strip((String)p, (String)"/?&");
                this.path.append(PATH_SEPERATOR).append(p);
            }
        }
        this.trailingSlash = true;
        return this;
    }

    public UrlBuilder addPage(String page) {
        if (StringUtils.isNotBlank((String)page)) {
            page = StringUtils.strip((String)page, (String)"/?&");
            if (StringUtils.isBlank((String)this.path.toString())) {
                this.path.append(page);
            } else {
                this.path.append(PATH_SEPERATOR).append(page);
            }
        }
        this.trailingSlash = false;
        return this;
    }

    public UrlBuilder addParamsFromURL(String url, String ... ignoreKeys) {
        if (StringUtils.isNotBlank((String)url)) {
            List queryParams = URLEncodedUtils.parse((String)url, (Charset)Charset.forName("UTF-8"));
            if (queryParams == null) {
                return this;
            }
            for (NameValuePair param : queryParams) {
                if (!StringArrayUtils.isBlank((String[])ignoreKeys) && ArrayUtils.contains((Object[])ignoreKeys, (Object)param.getName())) continue;
                if (this.multiParams.containsKey(param.getName()) || this.params.containsKey(param.getName())) {
                    this.addMultiParam(param.getName(), param.getValue());
                    continue;
                }
                this.addParam(param.getName(), param.getValue(), true);
            }
        }
        return this;
    }

    public UrlBuilder addParam(String key, String value) {
        return this.addParam(key, value, true);
    }

    public UrlBuilder addParam(String key, int value) {
        return this.addParam(key, String.valueOf(value), true);
    }

    public UrlBuilder addParam(String key, int value, boolean override) {
        return this.addParam(key, String.valueOf(value), override);
    }

    public UrlBuilder addParam(String key, String value, boolean override) {
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value) && (!this.params.containsKey(key) || this.params.containsKey(key) && override)) {
            this.params.put(key, value);
        }
        return this;
    }

    public UrlBuilder addParam(String key, String[] values) {
        return this.addParam(key, values, true);
    }

    public UrlBuilder addParam(String key, String[] values, boolean override) {
        if (StringUtils.isNotBlank((String)key)) {
            if (override) {
                this.removeParam(key);
            }
            if (values != null && values.length > 0) {
                for (String value : values) {
                    this.addMultiParam(key, value);
                }
            }
        }
        return this;
    }

    public boolean hasParam(String key) {
        return this.multiParams.containsKey(key) || this.params.containsKey(key);
    }

    public UrlBuilder removeParam(String key) {
        if (StringUtils.isNotBlank((String)key)) {
            if (this.multiParams.containsKey(key)) {
                this.multiParams.remove(key);
            }
            if (this.params.containsKey(key)) {
                this.params.remove(key);
            }
        }
        return this;
    }

    public UrlBuilder removeDefault(String key, String value) {
        if (StringUtils.isNotBlank((String)key)) {
            if (this.multiParams.containsKey(key) && this.multiParams.get(key).contains(value)) {
                this.multiParams.get(key).remove(value);
            }
            if (this.params.containsKey(key) && StringUtils.equals((String)value, (String)this.params.get(key))) {
                this.params.remove(key);
            }
        }
        return this;
    }

    public UrlBuilder removeStartWith(String key, String value) {
        if (this.params.containsKey(key) && StringUtils.startsWith((String)this.params.get(key), (String)value)) {
            this.params.remove(key);
        }
        if (this.multiParams.containsKey(key)) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String string : this.multiParams.get(key)) {
                if (!StringUtils.startsWith((String)string, (String)value)) continue;
                toRemove.add(string);
            }
            if (toRemove.size() > 0) {
                this.multiParams.get(key).removeAll(toRemove);
            }
            if (this.multiParams.get(key).size() == 0) {
                this.removeParam(key);
            }
        }
        return this;
    }

    public void setDomain(String newDomain) {
        if (StringUtils.isNotBlank((String)newDomain)) {
            if (StringUtils.contains((String)newDomain, (String)"://")) {
                newDomain = StringUtils.substringAfter((String)newDomain, (String)"://");
            }
            this.domain = StringUtils.substringBefore((String)newDomain, (String)PATH_SEPERATOR);
            this.disableDomain = false;
            this.disableProtocol = false;
        }
    }

    public UrlBuilder addMultiParam(String key, String value) {
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            List<Object> list = null;
            if (this.multiParams.containsKey(key)) {
                list = this.multiParams.get(key);
            } else {
                list = new ArrayList();
                this.multiParams.put(key, list);
                if (this.params.containsKey(key)) {
                    list.add(this.params.get(key));
                    this.params.remove(key);
                }
            }
            if (!list.contains(value)) {
                list.add(value);
            }
        }
        return this;
    }

    private StringBuilder createCanonical() {
        StringBuilder sb = new StringBuilder();
        if (!this.disableDomain && StringUtils.isNotBlank((String)this.domain)) {
            if (!this.disableProtocol) {
                sb.append(this.protocol).append("://");
            }
            sb.append(this.domain);
            if (this.port != 80) {
                sb.append(":").append(this.port);
            }
        }
        if (this.path != null) {
            sb.append(this.path.toString());
        }
        if (this.trailingSlash) {
            sb.append(PATH_SEPERATOR);
        }
        return sb;
    }

    public String toCanonicalUrl() throws InvalidUrlException {
        if (this.disableDomain || this.disableProtocol || StringUtils.isBlank((String)this.domain)) {
            throw new InvalidUrlException();
        }
        return this.createCanonical().toString();
    }

    public String toString() {
        StringBuilder sb = this.createCanonical();
        if (this.params.size() + this.multiParams.size() > 0) {
            boolean first = true;
            sb.append("?");
            for (String key : this.params.keySet()) {
                if (!first) {
                    sb.append("&");
                }
                sb.append(key).append("=").append(this.encode(this.params.get(key)));
                first = false;
            }
            for (String key : this.multiParams.keySet()) {
                for (String s : this.multiParams.get(key)) {
                    if (!first) {
                        sb.append("&");
                    }
                    sb.append(key).append("=").append(this.encode(s));
                    first = false;
                }
            }
        }
        if (StringUtils.isNotBlank((String)this.anchor)) {
            sb.append("#").append(this.anchor);
        }
        return sb.toString();
    }

    private String encode(String value) {
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("UnsupportedEncodingException: " + e.getLocalizedMessage()));
        }
        return value;
    }
}

