/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import com.google.gson.Gson;
import eu.europeana.corelib.definitions.ApplicationContextContainer;
import eu.europeana.corelib.utils.model.LanguageVersion;
import eu.europeana.corelib.web.model.ApiResult;
import eu.europeana.corelib.web.model.wikipedia.WikipediaQuery;
import eu.europeana.corelib.web.service.WikipediaApiService;
import eu.europeana.corelib.web.service.impl.JsonApiServiceImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WikipediaApiServiceImpl
extends JsonApiServiceImpl
implements WikipediaApiService {
    private static final String LANGLINKS = ".wikipedia.org/w/api.php?action=query&prop=langlinks&lllimit=200&redirects=&format=json";
    private static Map<String, List<String>> removableParts = new HashMap<String, List<String>>();

    public static WikipediaApiService getBeanInstance() {
        try {
            return (WikipediaApiService)ApplicationContextContainer.getBean(WikipediaApiServiceImpl.class);
        }
        catch (NullPointerException e) {
            return new WikipediaApiServiceImpl();
        }
    }

    @Override
    public List<LanguageVersion> getVersionsInMultiLanguage(String title, List<String> languages) {
        ArrayList<LanguageVersion> translations = new ArrayList<LanguageVersion>();
        ArrayList<String> smallCaseTranslations = new ArrayList<String>();
        for (String languageCode : languages) {
            if (StringUtils.isBlank((String)languageCode)) continue;
            Map<String, String> langVersions = this.getVersionsInLanguage(title, languageCode);
            for (String language : languages) {
                String langVersion;
                if (!langVersions.containsKey(language) || !StringUtils.isNotBlank((String)langVersions.get(language)) || smallCaseTranslations.contains((langVersion = String.format("%s (%s)", langVersions.get(language), language)).toLowerCase())) continue;
                smallCaseTranslations.add(langVersion.toLowerCase());
                translations.add(new LanguageVersion(langVersions.get(language), language));
            }
        }
        return translations;
    }

    @Override
    public Map<String, String> getVersionsInLanguage(String title, String languageCode) {
        String url = this.buildLanguageLinksUrl(title, languageCode);
        ApiResult result = this.getJsonResponse(url);
        WikipediaQuery wikipediaQuery = this.parseJson(result);
        return this.extractLanguageVersions(wikipediaQuery, languageCode);
    }

    private Map<String, String> extractLanguageVersions(WikipediaQuery query, String languageCode) {
        WikipediaQuery.Query.Page page;
        HashMap<String, String> languageVersions = new HashMap<String, String>();
        if (query != null && query.getQuery() != null && query.getQuery().getPages() != null && (page = query.getQuery().getPages().values().iterator().next()) != null && page.getPageid() != 0L) {
            if (page.getLanglinks() != null && page.getLanglinks().size() > 0) {
                for (WikipediaQuery.Query.Page.WikiLangLink langLinks : page.getLanglinks()) {
                    languageVersions.put(langLinks.getLang(), this.clearRemovableParts(langLinks.getLang(), langLinks.getTranslation()));
                }
            }
            if (!languageVersions.containsKey(languageCode)) {
                languageVersions.put(languageCode, page.getTitle());
            }
        }
        return languageVersions;
    }

    private String clearRemovableParts(String lang, String translation) {
        List<String> removables = removableParts.get(lang);
        if (removables != null) {
            for (String removable : removables) {
                translation = StringUtils.removeEnd((String)translation, (String)removable).trim();
            }
        }
        return translation;
    }

    private WikipediaQuery parseJson(ApiResult result) {
        Gson gson = new Gson();
        return (WikipediaQuery)gson.fromJson(result.getContent(), WikipediaQuery.class);
    }

    private String buildLanguageLinksUrl(String titles, String languageCode) {
        StringBuilder url = new StringBuilder("http://");
        url.append(this.checkLanguageCode(languageCode, "en"));
        url.append(LANGLINKS);
        try {
            url.append("&titles=").append(URLEncoder.encode(titles, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url.toString();
    }

    private String checkLanguageCode(String languageCode, String defaultLanguageCode) {
        if (this.isValidLanguageCode(languageCode)) {
            return languageCode;
        }
        return defaultLanguageCode;
    }

    private boolean isValidLanguageCode(String languageCode) {
        return StringUtils.isNotBlank((String)languageCode) && StringUtils.isAllLowerCase((String)languageCode) && languageCode.length() == 2;
    }

    static {
        removableParts.put("de", Arrays.asList("(Film)", "(Biologie)"));
        removableParts.put("en", Arrays.asList("(disambiguation)", "(film)"));
        removableParts.put("nl", Collections.singletonList("(film)"));
    }
}

