/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.model;

import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.web.exception.InvalidUrlException;
import eu.europeana.corelib.web.model.PageInfo;
import eu.europeana.corelib.web.utils.UrlBuilder;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public abstract class PageData {
    public static final String PARAM_MODEL = "model";
    private static final String EUROPEANA_PROVIDERS = "europeana-providers.html";
    private static final String PROVIDER_DESCRIPTION = ", Overview of collections included in Europeana";
    private Locale locale;
    private User user;
    private boolean debug = false;
    private boolean minify = true;
    private boolean indexable = false;
    private String googleAnalyticsId = "UA-XXXXXXXX-1";
    private String googleMapsId;
    private String bingTranslateId;
    private String addThisId;
    private String shareThisId;
    private String facebookId;
    private String cacheUrl;
    private String portalServer;
    private PageInfo pageInfo;
    private String pageTitle;
    private String metaCanonicalUrl;
    private String currentUrl;
    private boolean embedded = false;
    private String announceMsg = null;

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.minify = !debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setMinify(boolean minify) {
        this.minify = minify;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public void setIndexable(boolean indexable) {
        this.indexable = indexable;
    }

    public boolean isIndexable() {
        return this.indexable;
    }

    public final boolean isIndexingBlocked() {
        return !this.indexable;
    }

    public void setGoogleAnalyticsId(String googleAnalyticsId) {
        this.googleAnalyticsId = googleAnalyticsId;
    }

    public String getGoogleAnalyticsId() {
        return this.googleAnalyticsId;
    }

    public void setCacheUrl(String cacheUrl) {
        this.cacheUrl = cacheUrl;
    }

    public String getCacheUrl() {
        return this.cacheUrl;
    }

    public void setPortalServer(String portalServer) {
        this.portalServer = portalServer;
    }

    public String getPortalServer() {
        return this.portalServer;
    }

    public String getPortalServerSlashless() {
        return StringUtils.stripEnd((String)this.portalServer, (String)"/");
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public String getPageName() {
        return this.getPageInfo().getPageName();
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String getEmbeddedString() {
        return this.embedded ? "true" : "false";
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getPageTitle() {
        String pageTitle = "";
        if (StringUtils.isBlank((String)this.pageTitle)) {
            if (this.pageInfo != null && !StringUtils.isBlank((String)this.pageInfo.getPageTitle())) {
                pageTitle = this.pageInfo.getPageTitle();
            }
        } else {
            pageTitle = this.pageTitle;
        }
        return StringUtils.equals((String)this.getPageName(), (String)EUROPEANA_PROVIDERS) ? pageTitle + PROVIDER_DESCRIPTION : pageTitle;
    }

    public void setCurrentUrl(String currentUrl) {
        this.currentUrl = currentUrl;
    }

    public String getCurrentUrl() {
        return StringUtils.defaultIfBlank((String)this.currentUrl, (String)"");
    }

    public void setGoogleMapsId(String googleMapsId) {
        this.googleMapsId = googleMapsId;
    }

    public String getGoogleMapsId() {
        return this.googleMapsId;
    }

    public void setAddThisId(String addThisId) {
        this.addThisId = addThisId;
    }

    public String getAddThisId() {
        return this.addThisId;
    }

    public void setShareThisId(String shareThisId) {
        this.shareThisId = shareThisId;
    }

    public String getShareThisId() {
        return this.shareThisId;
    }

    public boolean isShowDidYouMean() {
        return false;
    }

    public String getMetaCanonicalUrl() {
        UrlBuilder url = new UrlBuilder(this.getCurrentUrl());
        url.setDomain(this.metaCanonicalUrl);
        try {
            return url.toCanonicalUrl();
        }
        catch (InvalidUrlException e) {
            return StringUtils.defaultIfBlank((String)this.metaCanonicalUrl, (String)this.getCurrentUrl());
        }
    }

    public void setMetaCanonicalUrl(String metaCanonicalUrl) {
        this.metaCanonicalUrl = metaCanonicalUrl;
    }

    public String getFacebookId() {
        return this.facebookId;
    }

    public void setFacebookId(String facebookId) {
        this.facebookId = facebookId;
    }

    public String getBingTranslateId() {
        return this.bingTranslateId;
    }

    public void setBingTranslateId(String bingTranslateId) {
        this.bingTranslateId = bingTranslateId;
    }

    public String getAnnounceMsg() {
        return this.announceMsg;
    }

    public void setAnnounceMsg(String announceMsg) {
        this.announceMsg = announceMsg;
    }
}

