/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.model.rights;

import eu.europeana.corelib.definitions.model.RightsOption;
import eu.europeana.corelib.definitions.solr.model.QueryFacet;
import eu.europeana.corelib.definitions.solr.model.TaggedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class RightReusabilityCategorizer {
    public static final String OPEN = "open";
    public static final String RESTRICTED = "restricted";
    public static final String UNCATEGORIZED = "uncategorized";
    public static final String PERMISSION = "permission";
    public static final int PERMISSION_STRATEGY_NEGATIVE_ALL = 1;
    public static final int PERMISSION_STRATEGY_NEGATIVE_WITH_RIGHTS = 2;
    public static final int PERMISSION_STRATEGY_POSITIVE = 3;
    private static int permissionStrategy = 1;
    private static final int SELECTED_OPEN = 1;
    private static final int SELECTED_RESTRICTED = 2;
    private static final int SELECTED_PERMISSION = 4;
    private static int savedStrategy = 0;
    private static Map<String, String> reusabilityValueMap = new LinkedHashMap<String, String>();
    private long numberOfOpen = 0L;
    private long numberOfRestricted = 0L;
    private long numberOfPermission = 0L;
    private static List<String> openUrls;
    private static String openRightsQuery;
    private static String noOpenRightsQuery;
    private static List<String> restrictedUrls;
    private static String restrictedRightsQuery;
    private static String noRestrictedRightsQuery;
    private static List<String> permissionUrls;
    private static String permissionRightsQuery;
    private static String allRightsQuery;
    private static Map<String, String> examinedUrlsMap;
    private static List<QueryFacet> queryFacets;

    public String categorize(String url, long count) {
        String cleanedUrl = this.cleanUrl(url);
        String category = null;
        if (StringUtils.isBlank((String)cleanedUrl)) {
            return category;
        }
        if (examinedUrlsMap.containsKey(cleanedUrl)) {
            category = examinedUrlsMap.get(cleanedUrl);
            if (category.equals(OPEN)) {
                this.numberOfOpen += count;
            } else if (category.equals(RESTRICTED)) {
                this.numberOfRestricted += count;
            }
        } else {
            for (String rightUrl : openUrls) {
                if (!cleanedUrl.startsWith(rightUrl)) continue;
                this.numberOfOpen += count;
                category = OPEN;
                examinedUrlsMap.put(cleanedUrl, category);
                break;
            }
            if (category == null) {
                for (String rightUrl : restrictedUrls) {
                    if (!cleanedUrl.startsWith(rightUrl)) continue;
                    this.numberOfRestricted += count;
                    category = RESTRICTED;
                    examinedUrlsMap.put(cleanedUrl, category);
                    break;
                }
            }
            if (category == null) {
                examinedUrlsMap.put(cleanedUrl, UNCATEGORIZED);
            }
        }
        return category;
    }

    public static String getOpenRightsQuery() {
        if (openRightsQuery == null) {
            openRightsQuery = RightReusabilityCategorizer.join(RightReusabilityCategorizer.solarizeUrls(openUrls));
        }
        return openRightsQuery;
    }

    public static String getNoOpenRightsQuery() {
        if (noOpenRightsQuery == null) {
            noOpenRightsQuery = RightReusabilityCategorizer.joinNegatives(RightReusabilityCategorizer.solarizeUrls(openUrls));
        }
        return noOpenRightsQuery;
    }

    public static String getRestrictedRightsQuery() {
        if (restrictedRightsQuery == null) {
            restrictedRightsQuery = RightReusabilityCategorizer.join(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
        }
        return restrictedRightsQuery;
    }

    public static String getNoRestrictedRightsQuery() {
        if (noRestrictedRightsQuery == null) {
            noRestrictedRightsQuery = RightReusabilityCategorizer.joinNegatives(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
        }
        return noRestrictedRightsQuery;
    }

    public static String getAllRightsQuery() {
        if (allRightsQuery == null) {
            ArrayList<String> solarizedUrls = new ArrayList<String>();
            solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(openUrls));
            solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
            allRightsQuery = RightReusabilityCategorizer.join(solarizedUrls);
        }
        return allRightsQuery;
    }

    public static String getPermissionRightsQuery() {
        if (permissionRightsQuery == null || savedStrategy != permissionStrategy) {
            if (permissionStrategy == 3) {
                permissionRightsQuery = RightReusabilityCategorizer.join(RightReusabilityCategorizer.solarizeUrls(permissionUrls));
            } else {
                ArrayList<String> solarizedUrls = new ArrayList<String>();
                solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(openUrls));
                solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
                permissionRightsQuery = permissionStrategy == 2 ? RightReusabilityCategorizer.joinNegatives(solarizedUrls) : RightReusabilityCategorizer.joinAllNegatives(solarizedUrls);
            }
            savedStrategy = permissionStrategy;
        }
        return permissionRightsQuery;
    }

    private static List<String> solarizeUrls(List<String> urls) {
        ArrayList<String> solarizedUrls = new ArrayList<String>();
        for (String url : urls) {
            solarizedUrls.add(RightReusabilityCategorizer.solarizeUrl(url));
        }
        return solarizedUrls;
    }

    private static String solarizeUrl(String url) {
        return url.replace(":", "\\:").replace("/", "\\/") + "*";
    }

    private static String rights(String content) {
        return "RIGHTS:(" + content + ")";
    }

    private static String join(List<String> urls) {
        return RightReusabilityCategorizer.rights(StringUtils.join(urls, (String)" OR "));
    }

    private static String joinNegatives(List<String> urls) {
        return RightReusabilityCategorizer.rights("NOT(" + StringUtils.join(urls, (String)" OR ") + ")");
    }

    private static String joinAllNegatives(List<String> urls) {
        return RightReusabilityCategorizer.joinNegatives(urls);
    }

    public static List<QueryFacet> getQueryFacets() {
        if (queryFacets == null) {
            queryFacets = new ArrayList<QueryFacet>();
            queryFacets.add(new QueryFacet(RightReusabilityCategorizer.getOpenRightsQuery(), "REUSABILITY:open", "REUSABILITY"));
            queryFacets.add(new QueryFacet(RightReusabilityCategorizer.getRestrictedRightsQuery(), "REUSABILITY:restricted", "REUSABILITY"));
            queryFacets.add(new QueryFacet(RightReusabilityCategorizer.getPermissionRightsQuery(), "REUSABILITY:permission", "REUSABILITY"));
        }
        return queryFacets;
    }

    private String cleanUrl(String url) {
        return url.trim().replace("&qf=RIGHTS:", "").replace("\"", "").replace("RIGHTS:", "");
    }

    public long getNumberOfOpen() {
        return this.numberOfOpen;
    }

    public long getNumberOfRestricted() {
        return this.numberOfRestricted;
    }

    public long getNumberOfPermission() {
        return this.numberOfPermission;
    }

    public static String getTranslationKey(String value) {
        return reusabilityValueMap.containsKey(value.toLowerCase()) ? reusabilityValueMap.get(value.toLowerCase()) : null;
    }

    public static Map<String, String> getReusabilityValueMap() {
        return reusabilityValueMap;
    }

    public static int getPermissionStrategy() {
        return permissionStrategy;
    }

    public static void setPermissionStrategy(int permissionStrategy) {
        RightReusabilityCategorizer.permissionStrategy = permissionStrategy;
    }

    public static Map<String, String> mapValueReplacements(String[] qf) {
        return RightReusabilityCategorizer.mapValueReplacements(qf, false);
    }

    public static Map<String, String> mapValueReplacements(String[] qf, boolean fromApi) {
        TaggedQuery query;
        if (ArrayUtils.isEmpty((Object[])qf)) {
            return null;
        }
        HashMap<String, String> valueReplacements = new HashMap<String, String>();
        String open = "REUSABILITY:open";
        String restricted = "REUSABILITY:restricted";
        String permission = "REUSABILITY:permission";
        int reusabilityFilters = 0;
        for (String value : qf) {
            TaggedQuery query2;
            if (value.equalsIgnoreCase(open) || fromApi && value.equalsIgnoreCase(OPEN)) {
                query2 = new TaggedQuery("REUSABILITY", RightReusabilityCategorizer.getOpenRightsQuery());
                valueReplacements.put(open, query2.toString());
                ++reusabilityFilters;
                continue;
            }
            if (value.equalsIgnoreCase(restricted) || fromApi && value.equalsIgnoreCase(RESTRICTED)) {
                query2 = new TaggedQuery("REUSABILITY", RightReusabilityCategorizer.getRestrictedRightsQuery());
                valueReplacements.put(restricted, query2.toString());
                reusabilityFilters += 2;
                continue;
            }
            if (!value.equalsIgnoreCase(permission) && (!fromApi || !value.equalsIgnoreCase(PERMISSION))) continue;
            query2 = new TaggedQuery("REUSABILITY", RightReusabilityCategorizer.getPermissionRightsQuery());
            valueReplacements.put(permission, query2.toString());
            reusabilityFilters += 4;
        }
        if (reusabilityFilters == 3) {
            query = new TaggedQuery("REUSABILITY", RightReusabilityCategorizer.getAllRightsQuery());
            valueReplacements.put(open, query.toString());
            valueReplacements.put(restricted, "");
        } else if (reusabilityFilters == 5) {
            query = new TaggedQuery("REUSABILITY", RightReusabilityCategorizer.getNoRestrictedRightsQuery());
            valueReplacements.put(open, query.toString());
            valueReplacements.put(permission, "");
        } else if (reusabilityFilters == 6) {
            query = new TaggedQuery("REUSABILITY", RightReusabilityCategorizer.getNoOpenRightsQuery());
            valueReplacements.put(restricted, query.toString());
            valueReplacements.put(permission, "");
        } else if (reusabilityFilters == 7) {
            valueReplacements.put(open, "");
            valueReplacements.put(restricted, "");
            valueReplacements.put(permission, "");
        }
        return valueReplacements;
    }

    static {
        reusabilityValueMap.put(OPEN, "reusabilityOpen_t");
        reusabilityValueMap.put(RESTRICTED, "reusabilityRestricted_t");
        reusabilityValueMap.put(PERMISSION, "reusabilityPermission_t");
        reusabilityValueMap = Collections.unmodifiableMap(reusabilityValueMap);
        openUrls = new ArrayList<String>();
        openUrls.add(RightsOption.CC_NOC.getUrl());
        openUrls.add(RightsOption.CC_ZERO.getUrl() + "/1.0/");
        openUrls.add(RightsOption.CC_BY.getUrl());
        openUrls.add(RightsOption.CC_BY_SA.getUrl());
        restrictedUrls = new ArrayList<String>();
        restrictedUrls.add(RightsOption.CC_BY_NC.getUrl());
        restrictedUrls.add(RightsOption.CC_BY_NC_SA.getUrl());
        restrictedUrls.add(RightsOption.CC_BY_NC_ND.getUrl());
        restrictedUrls.add(RightsOption.CC_BY_ND.getUrl());
        restrictedUrls.add(RightsOption.EU_OOC_NC.getUrl());
        restrictedUrls.add(RightsOption.RS_INC_EDU.getUrl());
        restrictedUrls.add(RightsOption.RS_NOC_NC.getUrl());
        restrictedUrls.add(RightsOption.RS_NOC_OKLR.getUrl());
        permissionUrls = new ArrayList<String>();
        permissionUrls.add(RightsOption.EU_RR_F.getUrl());
        permissionUrls.add(RightsOption.EU_RR_P.getUrl());
        permissionUrls.add(RightsOption.EU_RR_R.getUrl());
        permissionUrls.add(RightsOption.EU_U.getUrl());
        permissionUrls.add(RightsOption.EU_ORPHAN.getUrl());
        permissionUrls.add(RightsOption.RS_INC.getUrl());
        permissionUrls.add(RightsOption.RS_INC_OW_EU.getUrl());
        permissionUrls.add(RightsOption.RS_CNE.getUrl());
        examinedUrlsMap = new HashMap<String, String>();
    }
}

