/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.model.mediaservice;

import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.web.model.mediaservice.MediaService;
import eu.europeana.corelib.web.model.mediaservice.soundcloud.Track;
import eu.europeana.corelib.web.service.SoundCloudApiService;
import javax.annotation.Resource;

public class SoundCloud
extends MediaService {
    @Resource
    private SoundCloudApiService service;
    private String trackId;
    private String path;
    protected String urlPattern = "http://soundcloud.com/%s";
    protected String embeddedUrlPattern = "https://w.soundcloud.com/player/?url=https%%3A//api.soundcloud.com/tracks/%s&amp;auto_play=false&amp;hide_related=false&amp;visual=true";
    protected String embeddedHtmlPattern = "<iframe width=\"100%%\" height=\"450\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?url=https%%3A//api.soundcloud.com/tracks/%s&amp;auto_play=false&amp;hide_related=false&amp;visual=true\"></iframe>";

    public SoundCloud(String id) {
        super(id);
        this.resolve();
    }

    public SoundCloud(String id, SoundCloudApiService service) {
        super(id);
        this.service = service;
        this.resolve();
    }

    private void resolve() {
        Track response = null;
        response = this.id.contains("/") ? this.service.resolvePath(this.id) : this.service.getTrackInfo(this.id);
        this.path = response.getPath();
        this.trackId = response.getId();
    }

    @Override
    public String getUrl() {
        return String.format(this.getUrlPattern(), this.path);
    }

    @Override
    public String getEmbeddedUrl() {
        return String.format(this.getEmbeddedUrlPattern(), this.trackId);
    }

    @Override
    public String getEmbeddedHtml() {
        return String.format(this.getEmbeddedHtmlPattern(), this.trackId);
    }

    @Override
    public DocType getDataType() {
        return DocType.SOUND;
    }

    @Override
    protected String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    protected String getEmbeddedUrlPattern() {
        return this.embeddedUrlPattern;
    }

    @Override
    protected String getEmbeddedHtmlPattern() {
        return this.embeddedHtmlPattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.embeddedHtmlPattern == null ? 0 : this.embeddedHtmlPattern.hashCode());
        result = 31 * result + (this.embeddedUrlPattern == null ? 0 : this.embeddedUrlPattern.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        result = 31 * result + (this.trackId == null ? 0 : this.trackId.hashCode());
        result = 31 * result + (this.urlPattern == null ? 0 : this.urlPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoundCloud other = (SoundCloud)obj;
        if (this.embeddedHtmlPattern == null ? other.embeddedHtmlPattern != null : !this.embeddedHtmlPattern.equals(other.embeddedHtmlPattern)) {
            return false;
        }
        if (this.embeddedUrlPattern == null ? other.embeddedUrlPattern != null : !this.embeddedUrlPattern.equals(other.embeddedUrlPattern)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
            return false;
        }
        if (this.trackId == null ? other.trackId != null : !this.trackId.equals(other.trackId)) {
            return false;
        }
        return !(this.urlPattern == null ? other.urlPattern != null : !this.urlPattern.equals(other.urlPattern));
    }
}

