/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.swift;

import org.jclouds.ContextBuilder;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.features.ContainerApi;
import org.jclouds.openstack.swift.v1.features.ObjectApi;

public class SwiftProvider {
    private ObjectApi objectApi;

    public SwiftProvider(String authUrl, String userName, String password, String containerName, String regionName, String tenantName) {
        SwiftApi swiftApi = (SwiftApi)ContextBuilder.newBuilder((String)"openstack-swift").credentials(tenantName + ":" + userName, password).endpoint(authUrl).buildApi(SwiftApi.class);
        ContainerApi containerApi = swiftApi.getContainerApi(regionName);
        if (containerApi.get(containerName) == null && !containerApi.create(containerName)) {
            throw new RuntimeException("swift cannot create container: " + containerName);
        }
        this.objectApi = swiftApi.getObjectApi(regionName, containerName);
    }

    public ObjectApi getObjectApi() {
        return this.objectApi;
    }
}

