/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import com.google.gson.Gson;
import eu.europeana.corelib.web.model.ApiResult;
import eu.europeana.corelib.web.model.mediaservice.soundcloud.Track;
import eu.europeana.corelib.web.service.SoundCloudApiService;
import eu.europeana.corelib.web.service.impl.JsonApiServiceImpl;
import eu.europeana.corelib.web.support.Configuration;
import javax.annotation.Resource;

public class SoundCloudApiServiceImpl
extends JsonApiServiceImpl
implements SoundCloudApiService {
    @Resource
    private Configuration config;
    private static final String resolvePathUrl = "http://api.soundcloud.com/resolve.json?url=http://soundcloud.com/%s&client_id=%s";
    private static final String trackInfoUrl = "http://api.soundcloud.com/tracks/%s.json?client_id=%s";

    @Override
    public Track resolvePath(String path) {
        String apiUrl = this.buildResolverUrl(path);
        ApiResult apiResponse = this.getJsonResponse(apiUrl);
        return this.parseResolverJson(apiResponse);
    }

    @Override
    public Track getTrackInfo(String id) {
        String apiUrl = this.buildTrackInfoUrl(id);
        ApiResult apiResponse = this.getJsonResponse(apiUrl);
        return this.parseResolverJson(apiResponse);
    }

    private String buildResolverUrl(String path) {
        return String.format(resolvePathUrl, path, this.config.getSoundcloudClientID());
    }

    private String buildTrackInfoUrl(String id) {
        return String.format(trackInfoUrl, id, this.config.getSoundcloudClientID());
    }

    private Track parseResolverJson(ApiResult apiResponse) {
        Gson gson = new Gson();
        return (Track)gson.fromJson(apiResponse.getContent(), Track.class);
    }
}

