/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.model.mediaservice;

import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.web.model.mediaservice.MediaService;

public class Vimeo
extends MediaService {
    protected String urlPattern = "http://vimeo.com/%s";
    protected String embeddedUrlPattern = "http://player.vimeo.com/video/%s?title=0&byline=0&portrait=0";
    protected String embeddedHtmlPattern = "<iframe src=\"http://player.vimeo.com/video/%s?title=0&amp;byline=0&amp;portrait=0\" width=\"WIDTH\" height=\"HEIGHT\" frameborder=\"0\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe> <p><a href=\"http://vimeo.com/%s\">%s</a> on <a href=\"http://vimeo.com\">Vimeo</a>.</p>";

    public Vimeo(String id) {
        super(id);
    }

    @Override
    public String getEmbeddedHtml() {
        return String.format(this.getEmbeddedHtmlPattern(), this.id, this.id, this.id);
    }

    @Override
    public DocType getDataType() {
        return DocType.VIDEO;
    }

    @Override
    protected String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    protected String getEmbeddedUrlPattern() {
        return this.embeddedUrlPattern;
    }

    @Override
    protected String getEmbeddedHtmlPattern() {
        return this.embeddedHtmlPattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.embeddedHtmlPattern == null ? 0 : this.embeddedHtmlPattern.hashCode());
        result = 31 * result + (this.embeddedUrlPattern == null ? 0 : this.embeddedUrlPattern.hashCode());
        result = 31 * result + (this.urlPattern == null ? 0 : this.urlPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vimeo other = (Vimeo)obj;
        if (this.embeddedHtmlPattern == null ? other.embeddedHtmlPattern != null : !this.embeddedHtmlPattern.equals(other.embeddedHtmlPattern)) {
            return false;
        }
        if (this.embeddedUrlPattern == null ? other.embeddedUrlPattern != null : !this.embeddedUrlPattern.equals(other.embeddedUrlPattern)) {
            return false;
        }
        return !(this.urlPattern == null ? other.urlPattern != null : !this.urlPattern.equals(other.urlPattern));
    }
}

