/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.model.mediaservice;

import eu.europeana.corelib.web.model.mediaservice.AudioBoo;
import eu.europeana.corelib.web.model.mediaservice.DailyMotion;
import eu.europeana.corelib.web.model.mediaservice.MediaService;
import eu.europeana.corelib.web.model.mediaservice.MediaServiceFactory;
import eu.europeana.corelib.web.model.mediaservice.SoundCloud;
import eu.europeana.corelib.web.model.mediaservice.Vimeo;
import eu.europeana.corelib.web.model.mediaservice.Youtube;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public enum MediaServiceType {
    SOUNDCLOUD("^urn:soundcloud:(.*?)$", SoundCloud.class),
    VIMEO("^urn:vimeo:(.*?)$", Vimeo.class),
    YOUTUBE("^urn:youtube:(.*?)$", Youtube.class),
    AUDIOBOO("^urn:audioboo:(.*?)$", AudioBoo.class),
    DAILYMOTION("^urn:dailymotion:(.*?)$", DailyMotion.class);

    private Pattern urnPattern;
    private String urnPatternString;
    private Class<? extends MediaService> clazz;
    private MediaServiceFactory factory = MediaServiceFactory.getFactory();

    private MediaServiceType(String urnPatternString, Class<? extends MediaService> clazz) {
        this.urnPattern = Pattern.compile(urnPatternString);
        this.clazz = clazz;
    }

    public Pattern getUrnPattern() {
        return this.urnPattern;
    }

    public String getUrnPatternString() {
        return this.urnPatternString;
    }

    public static MediaService findInstance(String urn) {
        if (StringUtils.isNotBlank((String)urn)) {
            for (MediaServiceType service : MediaServiceType.values()) {
                MediaService mediaService = service.getInstance(urn);
                if (mediaService == null) continue;
                return mediaService;
            }
        }
        return null;
    }

    public MediaService getInstance(String urn) {
        Matcher matcher;
        if (StringUtils.isNotBlank((String)urn) && this.clazz != null && (matcher = this.urnPattern.matcher(urn)).find()) {
            return this.factory.create(this.clazz, matcher.group(1));
        }
        return null;
    }
}

