/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.model.mediaservice;

import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.web.model.mediaservice.MediaService;

public class DailyMotion
extends MediaService {
    protected String urlPattern = "http://www.dailymotion.com/video/%s";
    protected String embeddedUrlPattern = "http://www.dailymotion.com/embed/video/%s";
    protected String embeddedHtmlPattern = "<iframe frameborder=\"0\" width=\"480\" height=\"270\" src=\"http://www.dailymotion.com/embed/video/%s\" allowfullscreen></iframe><br /><a href=\"http://www.dailymotion.com/video/%s\" target=\"_blank\">%s</a>";

    public DailyMotion(String id) {
        super(id);
    }

    @Override
    public String getEmbeddedHtml() {
        return String.format(this.getEmbeddedHtmlPattern(), this.id, this.id, this.id);
    }

    @Override
    public DocType getDataType() {
        return DocType.VIDEO;
    }

    @Override
    protected String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    protected String getEmbeddedUrlPattern() {
        return this.embeddedUrlPattern;
    }

    @Override
    protected String getEmbeddedHtmlPattern() {
        return this.embeddedHtmlPattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.embeddedHtmlPattern == null ? 0 : this.embeddedHtmlPattern.hashCode());
        result = 31 * result + (this.embeddedUrlPattern == null ? 0 : this.embeddedUrlPattern.hashCode());
        result = 31 * result + (this.urlPattern == null ? 0 : this.urlPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DailyMotion other = (DailyMotion)obj;
        if (this.embeddedHtmlPattern == null ? other.embeddedHtmlPattern != null : !this.embeddedHtmlPattern.equals(other.embeddedHtmlPattern)) {
            return false;
        }
        if (this.embeddedUrlPattern == null ? other.embeddedUrlPattern != null : !this.embeddedUrlPattern.equals(other.embeddedUrlPattern)) {
            return false;
        }
        return !(this.urlPattern == null ? other.urlPattern != null : !this.urlPattern.equals(other.urlPattern));
    }
}

