/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.email.impl;

import eu.europeana.corelib.definitions.exception.ProblemType;
import eu.europeana.corelib.web.email.EmailBuilder;
import eu.europeana.corelib.web.email.model.EmailConfig;
import eu.europeana.corelib.web.exception.EmailServiceException;
import java.util.Map;
import javax.annotation.Resource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class EmailBuilderImpl
implements EmailBuilder {
    private static final String TEMPLATE_NAME_AFFIX_TEXT = ".txt.vm";
    private static final String TEMPLATE_NAME_AFFIX_HTML = ".html.vm";
    private String emailTo;
    private String emailFrom;
    private String subject;
    private Map<String, Object> model;
    @Resource
    private VelocityEngine engine;
    @Resource(name="corelib_web_emailConfigs")
    private Map<String, EmailConfig> configs;
    private EmailConfig config;

    public void prepare(MimeMessage mimeMessage) throws MessagingException {
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true);
        if (StringUtils.contains((String)this.emailTo, (String)",")) {
            message.setTo(StringUtils.split((String)this.emailTo, (String)","));
        } else {
            message.setTo(this.emailTo);
        }
        message.setFrom(this.emailFrom);
        message.setSubject(this.subject);
        String text = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.engine, (String)(this.config.getTemplate() + TEMPLATE_NAME_AFFIX_TEXT), (String)"UTF-8", this.model);
        String html = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.engine, (String)(this.config.getTemplate() + TEMPLATE_NAME_AFFIX_HTML), this.model);
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(text);
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setContent((Object)html, "text/html");
        message.getMimeMultipart().addBodyPart((BodyPart)textPart);
        message.getMimeMultipart().addBodyPart((BodyPart)htmlPart);
    }

    @Override
    public void setModel(Map<String, Object> model) {
        this.model = model;
    }

    @Override
    public void setEmailTo(String emailTo) {
        this.emailTo = emailTo;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    @Override
    public void setTemplate(String template) throws EmailServiceException {
        if (!this.configs.containsKey(template)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        this.config = this.configs.get(template);
        this.emailTo = this.config.getEmailTo();
        this.emailFrom = this.config.getEmailFrom();
        this.subject = this.config.getSubject();
    }
}

