/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.context;

import eu.europeana.corelib.utils.ConfigUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudFoundryVcapEnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.support.StandardServletEnvironment;

public class VcapPropertyLoader
extends CloudFoundryVcapEnvironmentPostProcessor {
    private static final Logger LOG = LogManager.getLogger((String)VcapPropertyLoader.class.getName());
    private static final String VCAP_API2_BASEURL = "api2_baseUrl";
    private static final String VCAP_GATEWAY_BASEURL = "apiGateway_baseUrl";
    private static final String VCAP_PORTAL_BASEURL = "portal_baseUrl";
    private static final String VCAP_MANIFEST_BASEURL = "iiifManifest_baseUrl";
    private static final StandardServletEnvironment env = new StandardServletEnvironment();
    private static final String ROUTE_BASEURL_PROP_REGEX = String.format("^route\\d+_(%s|%s|%s)", "api2_baseUrl", "apiGateway_baseUrl", "portal_baseUrl");

    public VcapPropertyLoader() {
        this.postProcessEnvironment((ConfigurableEnvironment)env, new SpringApplication(new Object[0]));
        ClassLoader c = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlC = (URLClassLoader)c;
        URL[] urls = urlC.getURLs();
        String path = urls[0].getPath();
        Properties props = new Properties();
        File europeanaProperties = new File(path + "/europeana.properties");
        try (FileInputStream fis = new FileInputStream(europeanaProperties);){
            props.load(fis);
            this.setVcapUrlProperty(props, VCAP_API2_BASEURL);
            this.setVcapUrlProperty(props, VCAP_GATEWAY_BASEURL);
            this.setVcapUrlProperty(props, VCAP_PORTAL_BASEURL);
            this.setVcapUrlProperty(props, VCAP_MANIFEST_BASEURL);
            List routeBaseUrls = ConfigUtils.getMatchingKeys((Map)env.getSystemEnvironment(), (String)ROUTE_BASEURL_PROP_REGEX);
            routeBaseUrls.forEach(key -> this.setVcapUrlProperty(props, (String)key));
            this.rewritePropertiesToFile(props, europeanaProperties);
        }
        catch (IOException e) {
            LOG.error("Error reading or writing properties", (Throwable)e);
        }
    }

    private void setVcapUrlProperty(Properties props, String vcapKey) {
        Object value = (String)env.getSystemEnvironment().get(vcapKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String propKey = StringUtils.replaceChars((String)vcapKey, (String)"_", (String)".");
            if (!StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)"http")) {
                value = "https://" + (String)value;
            }
            props.setProperty(propKey, (String)value);
            LOG.info("VCAP Url property {} with is added to application properties as {}. Value = {}", (Object)vcapKey, (Object)propKey, (Object)props.getProperty(propKey));
        }
    }

    private void rewritePropertiesToFile(Properties props, File propsFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("#Generated by the VcapPropertyLoader\n");
        sb.append("#").append(new Date().toString()).append("\n");
        for (Object key : props.keySet()) {
            sb.append(key).append("=").append(props.getProperty(key.toString())).append("\n");
        }
        FileUtils.writeStringToFile((File)propsFile, (String)(String.valueOf(sb) + "\n"), (boolean)false);
        LOG.debug("Properties: {}", (Object)sb.toString());
    }
}

