/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.exception;

import eu.europeana.corelib.web.exception.ProblemResponseAction;

public enum ProblemType {
    SEARCH_QUERY_INVALID("400-SA", "Invalid search query", ProblemResponseAction.LOG_WARN),
    SEARCH_CURSORMARK_INVALID("400-SC", "Invalid cursor value. Please make sure you encode the cursor value before sending it to the API.", ProblemResponseAction.LOG_WARN),
    SEARCH_START_AND_CURSOR("400-SD", "Parameters 'start' and 'cursorMark' cannot be used together", ProblemResponseAction.LOG_WARN),
    SEARCH_QUERY_EMPTY("400-SE", "Empty search query parameter", ProblemResponseAction.LOG_WARN),
    BOOST_PARAM_INVALID_FORMAT("400-SB", "Invalid boost parameter. Parameter should start with '{!edismax' and end with '}'.", ProblemResponseAction.LOG_ERR),
    BOOST_PARAM_INVALID_VALUE("400-SB", "Invalid boost parameter. Curly braces in between are not allowed", ProblemResponseAction.LOG_ERR),
    SEARCH_HITSELECTOR_INVALID("400-SH", "Invalid search hit selector value", ProblemResponseAction.LOG_WARN),
    SEARCH_PAGE_LIMIT_REACHED("400-SL", "It is not possible to paginate beyond the first 1000 search results. Please use cursor-based pagination instead", ProblemResponseAction.LOG_WARN),
    SEARCH_FACET_RANGE_INVALID("400-SR", "Invalid search facet range value", ProblemResponseAction.LOG_WARN),
    SEARCH_THEME_UNKNOWN("400-ST", "Theme does not exist", ProblemResponseAction.LOG_WARN),
    SEARCH_THEME_MULTIPLE("400-SU", "Theme parameter accepts one value only", ProblemResponseAction.LOG_WARN),
    CANT_CONNECT_SOLR("503-SA", "Unable to connect to search engine.", ProblemResponseAction.LOG_ERR),
    TIMEOUT_SOLR("504-SA", "Timeout connecting to search engine.", ProblemResponseAction.LOG_ERR),
    INVALIDCLASS(null, "Search service is called with invalid bean class.", ProblemResponseAction.LOG_ERR),
    APIKEY_MISSING("400-AM", "No API key provided", ProblemResponseAction.IGNORE),
    APIKEY_DOES_NOT_EXIST("401-AX", "API key doesn't exist", ProblemResponseAction.IGNORE),
    APIKEY_DEPRECATED("410-AD", "API key is deprecated", ProblemResponseAction.IGNORE),
    MONGO_UNREACHABLE(null, "Cannot connect to CHO database", ProblemResponseAction.LOG_ERR),
    RECORD_RETRIEVAL_ERROR(null, "Record retrieval error", ProblemResponseAction.LOG_ERR),
    MISSING_PARAMETER(null, "Missing required parameter", ProblemResponseAction.LOG_WARN),
    INVALID_PARAMETER_VALUE(null, "Invalid parameter value", ProblemResponseAction.LOG_WARN),
    INVALID_URL(null, "Url is invalid", ProblemResponseAction.LOG_ERR),
    CONFIG_ERROR(null, "Invalid application config", ProblemResponseAction.LOG_ERR),
    INVALID_AUTH_FOR_TRANSLATION(null, "Please provide authentication token for translation requests!!", ProblemResponseAction.LOG_ERR),
    TRANSLATION_API_URL_ERROR("null", "Translation API endpoint not configured.", ProblemResponseAction.LOG_ERR),
    TRANSLATION_SERVICE_DISABLED(null, "Sorry, there is no translation service available for this application", ProblemResponseAction.IGNORE),
    TRANSLATION_SERVICE_ERROR(null, "Error translating data", ProblemResponseAction.LOG_ERR),
    TRANSLATION_SERVICE_LIMIT_ERROR("502-TS", "Translation service not available !!", ProblemResponseAction.LOG_ERR),
    SERIALIZATION_ERROR(null, "Unexpected exception occurred when serializing.", ProblemResponseAction.LOG_ERR);

    private String errorCode;
    private String message;
    private ProblemResponseAction action;

    private ProblemType(String errorCode, String message, ProblemResponseAction action) {
        this.message = message;
        this.errorCode = errorCode;
        this.action = action;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public ProblemResponseAction getAction() {
        return this.action;
    }
}

