/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.web.email.EmailBuilder;
import eu.europeana.corelib.web.exception.EmailServiceException;
import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.service.EmailService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessagePreparator;

public abstract class EmailServiceImpl
implements EmailService {
    private static final Logger LOG = LogManager.getLogger(EmailServiceImpl.class);
    @Resource
    private JavaMailSenderImpl mailSender;

    @Override
    public void sendApiKeys(ApiKey apiKey) throws EmailServiceException {
        if (apiKey == null) {
            LOG.error("Problem with sendApiKeys: apiKey is null");
            throw new EmailServiceException(ProblemType.INVALID_ARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("apiKey", apiKey);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("apikeys");
        builder.setEmailTo(apiKey.getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        LOG.info("Sent API details to {}", (Object)apiKey.getEmail());
    }

    @Override
    public void sendException(String subject, String body) throws EmailServiceException {
        if (StringUtils.isBlank((CharSequence)subject) || StringUtils.isBlank((CharSequence)body)) {
            throw new EmailServiceException(ProblemType.INVALID_ARGUMENTS);
        }
        try {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("subject", subject);
            model.put("body", body);
            EmailBuilder builder = this.createEmailBuilder();
            builder.setModel(model);
            builder.setTemplate("exception");
            builder.setSubject(subject);
            this.mailSender.send((MimeMessagePreparator)builder);
        }
        catch (MailException me) {
            throw new EmailServiceException(ProblemType.MAIL_ERROR, (Throwable)me);
        }
    }

    protected abstract EmailBuilder createEmailBuilder();
}

