/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.model.rights;

import eu.europeana.corelib.definitions.model.RightsOption;
import eu.europeana.corelib.definitions.solr.model.QueryFacet;
import eu.europeana.corelib.definitions.solr.model.TaggedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RightReusabilityCategorizer {
    private long numberOfOpen = 0L;
    private long numberOfRestricted = 0L;
    private static String openRightsQuery;
    private static String restrictedRightsQuery;
    private static String permissionRightsQuery;
    private static String allRightsQuery;
    private static String uncategorizedQuery;
    private static Map<String, String> examinedUrlsMap;
    private static List<QueryFacet> queryFacets;
    private static int savedStrategy;
    static final int PERMISSION_STRATEGY_NEGATIVE_ALL = 1;
    static final int PERMISSION_STRATEGY_NEGATIVE_WITH_RIGHTS = 2;
    static final int PERMISSION_STRATEGY_POSITIVE = 3;
    private static int permissionStrategy;
    private static final int SELECTED_OPEN = 1;
    private static final int SELECTED_RESTRICTED = 2;
    private static final int SELECTED_PERMISSION = 4;
    private static final int SELECTED_UNCATEGORIZED = 7;
    private static final String OPEN = "open";
    private static final String RESTRICTED = "restricted";
    private static final String UNCATEGORIZED = "uncategorized";
    private static final String PERMISSION = "permission";
    private static final String REUSABILITY = "REUSABILITY";
    private static final String REUSABILITYLIST = "REUSABILITY:list";
    private static Map<String, String> reusabilityValueMap;
    private static List<String> openUrls;
    private static List<String> restrictedUrls;
    private static List<String> permissionUrls;

    public void categorize(String url, long count) {
        String cleanedUrl = this.cleanUrl(url);
        String category = null;
        if (examinedUrlsMap.containsKey(cleanedUrl)) {
            category = examinedUrlsMap.get(cleanedUrl);
            if (category.equals(OPEN)) {
                this.numberOfOpen += count;
            } else if (category.equals(RESTRICTED)) {
                this.numberOfRestricted += count;
            }
        } else {
            for (String rightUrl : openUrls) {
                if (!cleanedUrl.startsWith(rightUrl)) continue;
                this.numberOfOpen += count;
                category = OPEN;
                examinedUrlsMap.put(cleanedUrl, category);
                break;
            }
            if (category == null) {
                for (String rightUrl : restrictedUrls) {
                    if (!cleanedUrl.startsWith(rightUrl)) continue;
                    this.numberOfRestricted += count;
                    category = RESTRICTED;
                    examinedUrlsMap.put(cleanedUrl, category);
                    break;
                }
            }
            if (category == null) {
                examinedUrlsMap.put(cleanedUrl, UNCATEGORIZED);
            }
        }
    }

    static String getOpenRightsQuery() {
        if (openRightsQuery == null) {
            openRightsQuery = RightReusabilityCategorizer.join(RightReusabilityCategorizer.solarizeUrls(openUrls));
        }
        return openRightsQuery;
    }

    static String getRestrictedRightsQuery() {
        if (restrictedRightsQuery == null) {
            restrictedRightsQuery = RightReusabilityCategorizer.join(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
        }
        return restrictedRightsQuery;
    }

    static String getAllRightsQuery() {
        if (allRightsQuery == null) {
            ArrayList<String> solarizedUrls = new ArrayList<String>();
            solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(openUrls));
            solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
            allRightsQuery = RightReusabilityCategorizer.join(solarizedUrls);
        }
        return allRightsQuery;
    }

    static String getPermissionRightsQuery() {
        if (permissionRightsQuery == null || savedStrategy != permissionStrategy) {
            if (permissionStrategy == 3) {
                permissionRightsQuery = RightReusabilityCategorizer.join(RightReusabilityCategorizer.solarizeUrls(permissionUrls));
            } else {
                ArrayList<String> solarizedUrls = new ArrayList<String>();
                solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(openUrls));
                solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
                permissionRightsQuery = RightReusabilityCategorizer.joinNegatives(solarizedUrls);
            }
            savedStrategy = permissionStrategy;
        }
        return permissionRightsQuery;
    }

    private static String getUncategorizedQuery() {
        if (null == uncategorizedQuery) {
            ArrayList<String> solarizedUrls = new ArrayList<String>();
            solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(openUrls));
            solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(restrictedUrls));
            solarizedUrls.addAll(RightReusabilityCategorizer.solarizeUrls(permissionUrls));
            uncategorizedQuery = RightReusabilityCategorizer.joinNegatives(solarizedUrls);
        }
        return uncategorizedQuery;
    }

    private static List<String> solarizeUrls(List<String> urls) {
        ArrayList<String> solarizedUrls = new ArrayList<String>();
        for (String url : urls) {
            solarizedUrls.add(RightReusabilityCategorizer.solarizeUrl(url));
        }
        return solarizedUrls;
    }

    private static String solarizeUrl(String url) {
        return url.replace(":", "\\:").replace("/", "\\/") + "*";
    }

    private static String rights(String content) {
        return "RIGHTS:(" + content + ")";
    }

    private static String join(List<String> urls) {
        return RightReusabilityCategorizer.rights(StringUtils.join(urls, (String)" OR "));
    }

    private static String joinNegatives(List<String> urls) {
        return "-" + RightReusabilityCategorizer.rights(StringUtils.join(urls, (String)" OR "));
    }

    public static List<QueryFacet> getQueryFacets() {
        if (queryFacets == null) {
            queryFacets = new ArrayList<QueryFacet>();
            queryFacets.add(new QueryFacet(RightReusabilityCategorizer.getOpenRightsQuery(), "REUSABILITY:open", REUSABILITY));
            queryFacets.add(new QueryFacet(RightReusabilityCategorizer.getRestrictedRightsQuery(), "REUSABILITY:restricted", REUSABILITY));
            queryFacets.add(new QueryFacet(RightReusabilityCategorizer.getPermissionRightsQuery(), "REUSABILITY:permission", REUSABILITY));
            queryFacets.add(new QueryFacet(RightReusabilityCategorizer.getUncategorizedQuery(), "REUSABILITY:uncategorized", REUSABILITY));
        }
        return queryFacets;
    }

    private String cleanUrl(String url) {
        return url.trim().replace("&qf=RIGHTS:", "").replace("\"", "").replace("RIGHTS:", "");
    }

    public long getNumberOfOpen() {
        return this.numberOfOpen;
    }

    public long getNumberOfRestricted() {
        return this.numberOfRestricted;
    }

    static int getPermissionStrategy() {
        return permissionStrategy;
    }

    static void setPermissionStrategy(int permissionStrategy) {
        RightReusabilityCategorizer.permissionStrategy = permissionStrategy;
    }

    static Map<String, String> mapValueReplacements(String[] qf) {
        return RightReusabilityCategorizer.mapValueReplacements(qf, false);
    }

    public static Map<String, String> mapValueReplacements(String[] qf, boolean fromApi) {
        if (ArrayUtils.isEmpty((Object[])qf)) {
            return null;
        }
        HashMap<String, String> valueReplacements = new HashMap<String, String>();
        ArrayList<String> urlList = new ArrayList<String>();
        boolean negateQf = false;
        String open = "REUSABILITY:open";
        String restricted = "REUSABILITY:restricted";
        String permission = "REUSABILITY:permission";
        String uncategorized = "REUSABILITY:uncategorized";
        int reusabilityFilters = 0;
        for (String value : qf) {
            if (value.equalsIgnoreCase(open) || fromApi && value.equalsIgnoreCase(OPEN)) {
                ++reusabilityFilters;
                continue;
            }
            if (value.equalsIgnoreCase(restricted) || fromApi && value.equalsIgnoreCase(RESTRICTED)) {
                reusabilityFilters += 2;
                continue;
            }
            if (value.equalsIgnoreCase(permission) || fromApi && value.equalsIgnoreCase(PERMISSION)) {
                reusabilityFilters += 4;
                continue;
            }
            if (!value.equalsIgnoreCase(uncategorized) && (!fromApi || !value.equalsIgnoreCase(UNCATEGORIZED))) continue;
            reusabilityFilters -= 7;
            negateQf = true;
        }
        if (reusabilityFilters == 0) {
            return null;
        }
        if (Math.abs(reusabilityFilters) > 3) {
            urlList.addAll(permissionUrls);
            reusabilityFilters = negateQf ? (reusabilityFilters += 4) : (reusabilityFilters -= 4);
        }
        if (Math.abs(reusabilityFilters) > 1) {
            urlList.addAll(restrictedUrls);
            reusabilityFilters = negateQf ? (reusabilityFilters += 2) : (reusabilityFilters -= 2);
        }
        if (Math.abs(reusabilityFilters) > 0) {
            urlList.addAll(openUrls);
        }
        String urlString = RightReusabilityCategorizer.join(RightReusabilityCategorizer.solarizeUrls(urlList));
        if (negateQf) {
            urlString = "-" + urlString;
        }
        TaggedQuery query = new TaggedQuery(REUSABILITY, urlString);
        valueReplacements.put(REUSABILITYLIST, query.toString());
        return valueReplacements;
    }

    static {
        examinedUrlsMap = new HashMap<String, String>();
        savedStrategy = 0;
        permissionStrategy = 3;
        reusabilityValueMap = new LinkedHashMap<String, String>();
        reusabilityValueMap.put(OPEN, "reusabilityOpen_t");
        reusabilityValueMap.put(RESTRICTED, "reusabilityRestricted_t");
        reusabilityValueMap.put(PERMISSION, "reusabilityPermission_t");
        reusabilityValueMap = Collections.unmodifiableMap(reusabilityValueMap);
        openUrls = new ArrayList<String>();
        openUrls.add(RightsOption.CC_NOC.getUrl());
        openUrls.add(RightsOption.CC_ZERO.getUrl() + "1.0/");
        openUrls.add(RightsOption.CC_BY.getUrl());
        openUrls.add(RightsOption.CC_BY_SA.getUrl());
        restrictedUrls = new ArrayList<String>();
        restrictedUrls.add(RightsOption.CC_BY_NC.getUrl());
        restrictedUrls.add(RightsOption.CC_BY_NC_SA.getUrl());
        restrictedUrls.add(RightsOption.CC_BY_NC_ND.getUrl());
        restrictedUrls.add(RightsOption.CC_BY_ND.getUrl());
        restrictedUrls.add(RightsOption.EU_OOC_NC.getUrl());
        restrictedUrls.add(RightsOption.RS_INC_EDU.getUrl());
        restrictedUrls.add(RightsOption.RS_NOC_NC.getUrl());
        restrictedUrls.add(RightsOption.RS_NOC_OKLR.getUrl());
        permissionUrls = new ArrayList<String>();
        permissionUrls.add(RightsOption.EU_RR_F.getUrl());
        permissionUrls.add(RightsOption.EU_RR_P.getUrl());
        permissionUrls.add(RightsOption.EU_RR_R.getUrl());
        permissionUrls.add(RightsOption.EU_U.getUrl());
        permissionUrls.add(RightsOption.EU_ORPHAN.getUrl());
        permissionUrls.add(RightsOption.RS_INC.getUrl());
        permissionUrls.add(RightsOption.RS_INC_OW_EU.getUrl());
        permissionUrls.add(RightsOption.RS_CNE.getUrl());
    }
}

