/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.context;

import eu.europeana.corelib.web.socks.SocksProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudFoundryVcapEnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.support.StandardServletEnvironment;

public class VcapPropertyLoader
extends CloudFoundryVcapEnvironmentPostProcessor {
    private static final Logger LOG = LogManager.getLogger((String)VcapPropertyLoader.class.getName());
    private static final String VCAP_API2_BASEURL = "api2_baseUrl";
    private static final String VCAP_GATEWAY_BASEURL = "apiGateway_baseUrl";
    private static final String VCAP_PORTAL_BASEURL = "portal_baseUrl";
    private static StandardServletEnvironment env = new StandardServletEnvironment();

    public VcapPropertyLoader() {
        this.postProcessEnvironment((ConfigurableEnvironment)env, new SpringApplication(new Object[0]));
        ClassLoader c = ((Object)((Object)this)).getClass().getClassLoader();
        URLClassLoader urlC = (URLClassLoader)c;
        URL[] urls = urlC.getURLs();
        String path = urls[0].getPath();
        Properties props = new Properties();
        File europeanaProperties = new File(path + "/europeana.properties");
        try (FileInputStream fis = new FileInputStream(europeanaProperties);){
            props.load(fis);
            this.setVcapUrlProperty(props, VCAP_API2_BASEURL);
            this.setVcapUrlProperty(props, VCAP_GATEWAY_BASEURL);
            this.setVcapUrlProperty(props, VCAP_PORTAL_BASEURL);
            String host = props.getProperty("socks.host");
            Boolean enabled = Boolean.valueOf(props.getProperty("socks.enabled"));
            if (StringUtils.isEmpty((CharSequence)host)) {
                LOG.info("No socks proxy host configured");
            } else if (!enabled.booleanValue()) {
                LOG.info("Socks proxy disabled");
            } else {
                LOG.info("Setting up proxy at " + host);
                this.initSocksProxyConfig(host, props.getProperty("socks.port"), props.getProperty("socks.user"), props.getProperty("socks.password"));
            }
            this.rewritePropertiesToFile(props, europeanaProperties);
        }
        catch (IOException e) {
            LOG.error("Error reading or writing properties", (Throwable)e);
        }
    }

    private void setVcapUrlProperty(Properties props, String vcapKey) {
        String value = (String)env.getSystemEnvironment().get(vcapKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String propKey = StringUtils.replaceChars((String)vcapKey, (String)"_", (String)".");
            if (!StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)"http")) {
                value = "https://" + value;
            }
            props.setProperty(propKey, value);
            LOG.info("VCAP Url property {} with is added to application properties as {}. Value = {}", (Object)vcapKey, (Object)propKey, (Object)props.getProperty(propKey));
        }
    }

    private void rewritePropertiesToFile(Properties props, File propsFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("#Generated by the VcapPropertyLoader\n");
        sb.append("#").append(new Date().toString()).append("\n");
        for (Object key : props.keySet()) {
            sb.append(key).append("=").append(props.getProperty(key.toString())).append("\n");
        }
        FileUtils.writeStringToFile((File)propsFile, (String)(sb + "\n"), (boolean)false);
        LOG.info("Properties: {}", (Object)sb.toString());
    }

    private void initSocksProxyConfig(String host, String port, String user, String password) {
        SocksProxy socksProxy = new SocksProxy(host, port, user, password);
        socksProxy.init();
    }
}

