/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import eu.europeana.corelib.web.model.MediaFile;
import eu.europeana.corelib.web.service.MediaStorageService;
import eu.europeana.domain.ObjectMetadata;
import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.io.Payload;

@Deprecated
public class MediaStorageServiceImpl
implements MediaStorageService {
    private static final Logger LOG = LogManager.getLogger(MediaStorageServiceImpl.class);
    private ObjectStorageClient objectStorageClient;

    public MediaStorageServiceImpl(ObjectStorageClient objectStorageClient) {
        this.objectStorageClient = objectStorageClient;
    }

    @Override
    public Boolean checkIfExists(String id) {
        return this.objectStorageClient.isAvailable(id);
    }

    @Override
    public MediaFile retrieveAsMediaFile(String id, String originalUrl, boolean withContent) {
        StorageObject storageObject = this.retrieveAsStorageObject(id, withContent);
        if (storageObject == null) {
            return null;
        }
        byte[] content = null;
        if (withContent) {
            try {
                content = this.convertPayloadToByteArray(storageObject.getPayload());
            }
            catch (IOException e) {
                LOG.error("Error reading media file contents {}", (Object)id, (Object)e);
            }
        }
        return new MediaFile(storageObject.getName(), originalUrl, content, storageObject.getMetadata());
    }

    @Override
    public StorageObject retrieveAsStorageObject(String id, boolean withContent) {
        Optional optStorageObject;
        Optional optional = optStorageObject = withContent ? this.objectStorageClient.get(id) : this.objectStorageClient.getWithoutBody(id);
        if (!optStorageObject.isPresent()) {
            return null;
        }
        return (StorageObject)optStorageObject.get();
    }

    @Override
    public byte[] convertPayloadToByteArray(Payload payload) throws IOException {
        byte[] result = null;
        try (InputStream in = payload.openStream();){
            result = IOUtils.toByteArray((InputStream)in);
        }
        return result;
    }

    @Override
    public byte[] retrieveContent(String id) {
        return this.objectStorageClient.getContent(id);
    }

    @Override
    public ObjectMetadata retrieveMetaData(String id) {
        return this.objectStorageClient.getMetaData(id);
    }

    @Override
    @Deprecated
    public void createOrModify(MediaFile mediaFile) {
        throw new NotImplementedException("Functionality was removed to avoid accidental usage");
    }

    @Override
    @Deprecated
    public void delete(String id) {
        throw new NotImplementedException("Functionality was removed to avoid accidental usage");
    }
}

