/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.exception;

import eu.europeana.corelib.web.exception.ProblemResponseAction;

public enum ProblemType {
    SEARCH_QUERY_INVALID("400-SA", "Invalid search query", ProblemResponseAction.LOG_WARN),
    SEARCH_CURSORMARK_INVALID("400-SC", "Invalid cursor value. Please make sure you encode the cursor value before sending it to the API.", ProblemResponseAction.LOG_WARN),
    SEARCH_START_AND_CURSOR("400-SD", "Parameters 'start' and 'cursorMark' cannot be used together", ProblemResponseAction.LOG_WARN),
    SEARCH_QUERY_EMPTY("400-SE", "Empty search query parameter", ProblemResponseAction.LOG_WARN),
    SEARCH_HITSELECTOR_INVALID("400-SH", "Invalid search hit selector value", ProblemResponseAction.LOG_WARN),
    SEARCH_PAGE_LIMIT_REACHED("400-SL", "It is not possible to paginate beyond the first 1000 search results. Please use cursor-based pagination instead", ProblemResponseAction.LOG_WARN),
    SEARCH_FACET_RANGE_INVALID("400-SR", "Invalid search facet range value", ProblemResponseAction.LOG_WARN),
    SEARCH_THEME_UNKNOWN("400-ST", "Theme does not exist", ProblemResponseAction.LOG_WARN),
    SEARCH_THEME_MULTIPLE("400-SU", "Theme parameter accepts one value only", ProblemResponseAction.LOG_WARN),
    CANT_CONNECT_SOLR("503-SA", "Unable to connect to search engine.", ProblemResponseAction.MAIL),
    TIMEOUT_SOLR("504-SA", "Timeout connecting to search engine.", ProblemResponseAction.LOG_ERR),
    INVALIDCLASS(null, "Search service is called with invalid bean class.", ProblemResponseAction.MAIL),
    APIKEY_MISSING("400-AM", "No API key provided", ProblemResponseAction.IGNORE),
    APIKEY_DOES_NOT_EXIST("401-AX", "API key doesn't exist", ProblemResponseAction.IGNORE),
    APIKEY_DEPRECATED("410-AD", "API key is deprecated", ProblemResponseAction.IGNORE),
    APIKEY_ERROR("500-AE", "Error checking API key", ProblemResponseAction.LOG_ERR),
    MAIL_ERROR(null, "Error sending email", ProblemResponseAction.LOG_ERR),
    MONGO_UNREACHABLE(null, "Cannot connect to CHO database", ProblemResponseAction.MAIL),
    RECORD_RETRIEVAL_ERROR(null, "Record retrieval error", ProblemResponseAction.LOG_ERR),
    INCONSISTENT_DATA(null, "Inconsistent data", ProblemResponseAction.MAIL),
    INVALID_ARGUMENTS(null, "Service is called with invalid argument(s)", ProblemResponseAction.MAIL),
    NO_USERNAME(null, "User name does not exist.", ProblemResponseAction.IGNORE),
    NO_PASSWORD(null, "Password does not exist.", ProblemResponseAction.IGNORE),
    NEO4J_404(null, "No hierarchical data found for record", ProblemResponseAction.LOG_ERR),
    NEO4J_500(null, "Error processing hierarchical data for record", ProblemResponseAction.LOG_ERR),
    NEO4J_502_BAD_DATA(null, "Inconsistency in hierarchical data for record", ProblemResponseAction.LOG_ERR),
    NEO4J_503_CONNECTION(null, "Could not connect to hierarchy database", ProblemResponseAction.LOG_ERR),
    INVALID_URL(null, "Url is invalid", ProblemResponseAction.LOG_ERR),
    NOT_FOUND(null, "Entity doesn't exists", ProblemResponseAction.IGNORE),
    UNKNOWN(null, "unknown", ProblemResponseAction.IGNORE),
    TOKEN_INVALID(null, "Europeana token has expired and is no longer valid.", ProblemResponseAction.LOG_ERR),
    TOKEN_MISMATCH(null, "This Europeana token is not associated with the supplied email address.", ProblemResponseAction.LOG_ERR),
    TOKEN_OUTDATED(null, "Token is outdated.", ProblemResponseAction.LOG_ERR),
    NO_USER_ID(null, "User id does not exist.", ProblemResponseAction.IGNORE),
    NO_USER(null, "User does not exist.", ProblemResponseAction.IGNORE),
    MISSING_PARAM_USERNAME(null, "Required parameter 'username' missing.", ProblemResponseAction.IGNORE),
    MISSING_PARAM_EMAIL(null, "Required parameter 'email' missing.", ProblemResponseAction.IGNORE),
    MISSING_PARAM_PASSWORD(null, "Required parameter 'password' missing.", ProblemResponseAction.IGNORE),
    DUPLICATE(null, "Record already exists.", ProblemResponseAction.IGNORE);

    private String errorCode;
    private String message;
    private ProblemResponseAction action;

    private ProblemType(String errorCode, String message, ProblemResponseAction action) {
        this.message = message;
        this.errorCode = errorCode;
        this.action = action;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public ProblemResponseAction getAction() {
        return this.action;
    }
}

