/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.exception;

import eu.europeana.corelib.web.exception.ProblemResponseAction;
import eu.europeana.corelib.web.exception.ProblemType;
import org.apache.commons.lang3.StringUtils;

public abstract class EuropeanaException
extends Exception {
    private static final long serialVersionUID = 4759945931809288624L;
    private final ProblemType problem;
    private String errorDetails;

    public EuropeanaException(ProblemType problem) {
        this.problem = problem;
    }

    public EuropeanaException(ProblemType problem, String errorDetails) {
        this.problem = problem;
        this.errorDetails = errorDetails;
    }

    public EuropeanaException(ProblemType problem, Throwable causedBy) {
        super(causedBy);
        this.problem = problem;
        this.errorDetails = causedBy.getMessage();
    }

    public EuropeanaException(ProblemType problem, String errorDetails, Throwable causedBy) {
        super(causedBy);
        this.problem = problem;
        this.errorDetails = errorDetails;
    }

    public String getErrorCode() {
        return this.problem.getErrorCode();
    }

    @Override
    public String getMessage() {
        return this.problem.getMessage();
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String getErrorMsgAndDetails() {
        return this.problem.getMessage() + (StringUtils.isEmpty((CharSequence)this.errorDetails) ? "" : " - " + this.errorDetails);
    }

    public ProblemResponseAction getAction() {
        return this.problem.getAction();
    }

    @Deprecated
    public ProblemType getProblem() {
        return this.problem;
    }
}

