/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class Configuration {
    public static final String FACET_UCG_FILTER = "-UGC:true";
    public static final String FACET_TYPE = "TYPE:";
    public static final int DEFAULT_KEYWORD_LANGUAGES_LIMIT = 6;
    public static final String OLD_MYEUROPEANA_URL = "myeuropeana.html";
    public static final String NEW_MYEUROPEANA_URL = "myeuropeana";
    @Resource
    private Properties europeanaProperties;
    @Value(value="#{europeanaProperties['portal.server']}")
    private String portalServer;
    @Value(value="#{europeanaProperties['portal.server.canonical']}")
    private String cannonicalPortalServer;
    @Value(value="#{europeanaProperties['portal.theme']}")
    private String defaultTheme;
    @Value(value="#{europeanaProperties['static.page.path']}")
    private String staticPagePath;
    @Value(value="#{europeanaProperties['static.page.checkFrequencyInMinute']}")
    private Integer staticPageCheckFrequencyInMinute;
    @Value(value="#{europeanaProperties['static.page.suffix']}")
    private String staticPageSuffix;
    @Value(value="#{europeanaProperties['static.page.in.versions']}")
    private String staticPageInVersionsString;
    @Value(value="#{europeanaProperties['portal.blog.url']}")
    private String blogUrl;
    @Value(value="#{europeanaProperties['portal.blog.timeout']}")
    private Integer blogTimeout;
    @Value(value="#{europeanaProperties['portal.pinterest.url']}")
    private String pintUrl;
    @Value(value="#{europeanaProperties['portal.pinterest.feedurl']}")
    private String pintFeedUrl;
    @Value(value="#{europeanaProperties['portal.pinterest.timeout']}")
    private Integer pintTimeout;
    @Value(value="#{europeanaProperties['portal.pinterest.itemslimit']}")
    private Integer pintItemLimit;
    @Value(value="#{europeanaProperties['portal.google.plus.publisher.id']}")
    private String portalGooglePlusPublisherId;
    @Value(value="#{europeanaProperties['portal.responsive.widths']}")
    private String responsiveImageWidthString;
    @Value(value="#{europeanaProperties['portal.responsive.carousel.widths']}")
    private String responsiveCarouselImageWidthString;
    @Value(value="#{europeanaProperties['portal.responsive.labels']}")
    private String responsiveImageLabelString;
    @Value(value="#{europeanaProperties['portal.responsive.carousel.labels']}")
    private String responsiveCarouselImageLabelString;
    @Value(value="#{europeanaProperties['portal.shownAtProviderOverride']}")
    private String[] shownAtProviderOverride;
    @Value(value="#{europeanaProperties['api2.url']}")
    private String api2url;
    @Value(value="#{europeanaProperties['api2.canonical.url']}")
    private String api2canonicalUrl;
    @Value(value="#{europeanaProperties['api2.key']}")
    private String api2key;
    @Value(value="#{europeanaProperties['api2.secret']}")
    private String api2secret;
    @Value(value="#{europeanaProperties['schema.org.mapping']}")
    private String schemaOrgMappingFile;
    @Value(value="#{europeanaProperties['imageCacheUrl']}")
    private String imageCacheUrl;
    @Value(value="#{europeanaProperties['portal.minCompletenessToPromoteInSitemaps']}")
    private int minCompletenessToPromoteInSitemaps;
    @Value(value="#{europeanaProperties['portal.contentchecker']}")
    private String isContentChecker;
    @Value(value="#{europeanaProperties['portal.rowLimit']}")
    private String rowLimit;
    @Value(value="#{europeanaProperties['debug']}")
    private String debug;
    @Value(value="#{europeanaProperties['portal.responsive.cache']}")
    private String responsiveCache;
    @Value(value="#{europeanaProperties['portal.responsive.cache.checkFrequencyInMinute']}")
    private Integer responsiveCacheCheckFrequencyInMinute;
    @Value(value="#{europeanaProperties['api.optOutList']}")
    private String optOutList;
    @Value(value="#{europeanaProperties['api.rowLimit']}")
    private int apiRowLimit = 96;
    @Value(value="#{europeanaProperties['portal.sitemap.cache']}")
    private String sitemapCache;
    @Value(value="#{europeanaProperties['portal.soundCloudAwareCollections']}")
    private String soundCloudAwareCollectionsString;
    @Value(value="#{europeanaProperties['portal.mlt.weight.title']}")
    private double weightTitle;
    @Value(value="#{europeanaProperties['portal.mlt.weight.who']}")
    private double weightWho;
    @Value(value="#{europeanaProperties['portal.mlt.weight.what']}")
    private double weightWhat;
    @Value(value="#{europeanaProperties['portal.mlt.weight.provider']}")
    private double weightProvider;
    @Value(value="#{europeanaProperties['portal.mlt.weight.dataProvider']}")
    private double weightDataProvider;
    @Value(value="#{europeanaProperties['portal.keywordLanguagesLimit']}")
    private Integer keywordLanguagesLimit;
    @Value(value="#{europeanaProperties['portal.bing.translate.key']}")
    private String bingTranslateId;
    @Value(value="#{europeanaProperties['portal.useBackendItemTranslation']}")
    private String useBackendItemTranslationString;
    @Value(value="#{europeanaProperties['portal.useAutomatedFrontendTranslation']}")
    private String useAutomatedFrontendTranslationString;
    @Value(value="#{europeanaProperties['portal.soundcloud.clientID']}")
    private String soundcloudClientID;
    @Value(value="#{europeanaProperties['portal.hierarchyRoots']}")
    private String hierarchyRootsString;
    @Value(value="#{europeanaProperties['portal.bing.translate.clientId']}")
    private String bingTranslateClientId;
    @Value(value="#{europeanaProperties['portal.bing.translate.clientSecret']}")
    private String bingTranslateClientSecret;
    private Map<String, String> seeAlsoTranslations;
    private Map<String, String> seeAlsoAggregations;
    private Map<String, String> mltTranslations;
    private Map<String, String> gftChannelAttributes;
    private String portalUrl;
    private List<String> staticPageInVersions;
    private List<String> soundCloudAwareCollections;
    private List<String> hierarchyRoots;
    @Value(value="#{europeanaProperties['nof.enabled']}")
    private boolean nofEnabled;

    public String getBingTranslateClientId() {
        return this.bingTranslateClientId;
    }

    public void setBingTranslateClientId(String bingTranslateClientId) {
        this.bingTranslateClientId = bingTranslateClientId;
    }

    public String getBingTranslateClientSecret() {
        return this.bingTranslateClientSecret;
    }

    public void setBingTranslateClientSecret(String bingTranslateClientSecret) {
        this.bingTranslateClientSecret = bingTranslateClientSecret;
    }

    public String getPortalServer() {
        return this.portalServer;
    }

    public String getCannonicalPortalServer() {
        return this.cannonicalPortalServer;
    }

    public String[] getShownAtProviderOverride() {
        return this.shownAtProviderOverride;
    }

    public String getApi2url() {
        return this.api2url;
    }

    public String getApi2CanonicalUrl() {
        return this.api2canonicalUrl;
    }

    public String getApi2key() {
        return this.api2key;
    }

    public String getApi2secret() {
        return this.api2secret;
    }

    public String getSchemaOrgMappingFile() {
        return this.schemaOrgMappingFile;
    }

    public String getBlogUrl() {
        return this.blogUrl;
    }

    public int getBlogTimeout() {
        return this.blogTimeout;
    }

    public String getPintUrl() {
        return this.pintUrl;
    }

    public String getPintFeedUrl() {
        return this.pintFeedUrl;
    }

    public int getPintTimeout() {
        return this.pintTimeout;
    }

    public int getPintItemLimit() {
        return this.pintItemLimit;
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public String getStaticPagePath() {
        return this.staticPagePath;
    }

    public String getStaticPageSuffix() {
        return this.staticPageSuffix;
    }

    public String getPortalGooglePlusPublisherId() {
        return this.portalGooglePlusPublisherId;
    }

    public String getImageCacheUrl() {
        return this.imageCacheUrl;
    }

    public int getMinCompletenessToPromoteInSitemaps() {
        return this.minCompletenessToPromoteInSitemaps;
    }

    public boolean isContentChecker() {
        if (StringUtils.isBlank((String)this.isContentChecker)) {
            return false;
        }
        return Boolean.parseBoolean(this.isContentChecker);
    }

    public int getRowLimit() {
        return Integer.parseInt(this.rowLimit);
    }

    public boolean getDebugMode() {
        if (StringUtils.isBlank((String)this.debug)) {
            return false;
        }
        return Boolean.parseBoolean(this.debug);
    }

    public String getResponsiveCache() {
        return this.responsiveCache;
    }

    public Integer getResponsiveCacheCheckFrequencyInMinute() {
        return this.responsiveCacheCheckFrequencyInMinute;
    }

    public Map<String, String> getSeeAlsoTranslations() {
        if (this.seeAlsoTranslations == null) {
            this.seeAlsoTranslations = new HashMap<String, String>();
            int i = 1;
            while (this.europeanaProperties.containsKey("portal.seeAlso.field." + i)) {
                String[] parts = this.europeanaProperties.getProperty("portal.seeAlso.field." + i).split("=", 2);
                this.seeAlsoTranslations.put(parts[0].trim(), parts[1].trim());
                ++i;
            }
        }
        return this.seeAlsoTranslations;
    }

    public Map<String, String> getMltTranslations() {
        if (this.mltTranslations == null) {
            this.mltTranslations = new HashMap<String, String>();
            int i = 1;
            while (this.europeanaProperties.containsKey("portal.mlt.field." + i)) {
                String[] parts = this.europeanaProperties.getProperty("portal.mlt.field." + i).split("=", 2);
                this.mltTranslations.put(parts[0].trim(), parts[1].trim());
                ++i;
            }
        }
        return this.mltTranslations;
    }

    public Map<String, String> getSeeAlsoAggregations() {
        if (this.seeAlsoAggregations == null) {
            this.seeAlsoAggregations = new HashMap<String, String>();
            int i = 1;
            String key = "portal.seeAlso.aggregation.";
            while (this.europeanaProperties.containsKey(key + i)) {
                String[] parts = this.europeanaProperties.getProperty(key + i).split(",");
                int l = parts.length;
                for (int j = 1; j < l; ++j) {
                    this.seeAlsoAggregations.put(parts[j].trim(), parts[0].trim());
                }
                ++i;
            }
        }
        return this.seeAlsoAggregations;
    }

    public Map<String, String> getGftChannelAttributes(String channel) {
        this.gftChannelAttributes = new HashMap<String, String>();
        int i = 1;
        while (this.europeanaProperties.containsKey("gft.channel." + channel + "." + i)) {
            String[] parts = this.europeanaProperties.getProperty("gft.channel." + channel + "." + i).split("=", 2);
            this.gftChannelAttributes.put(parts[0].trim(), parts[1].trim());
            ++i;
        }
        return this.gftChannelAttributes;
    }

    public String getPortalUrl() {
        if (this.portalUrl == null) {
            StringBuilder sb = new StringBuilder(this.portalServer);
            if (!this.portalServer.endsWith("/")) {
                sb.append("/");
            }
            this.portalUrl = sb.toString();
        }
        return this.portalUrl;
    }

    public List<String> getStaticPageInVersions() {
        if (this.staticPageInVersions == null) {
            this.staticPageInVersions = new ArrayList<String>();
            if (StringUtils.isNotBlank((String)this.staticPageInVersionsString)) {
                String[] items;
                for (String item : items = this.staticPageInVersionsString.split(",")) {
                    this.staticPageInVersions.add(item.trim());
                }
            }
        }
        return this.staticPageInVersions;
    }

    public List<String> getSoundCloudAwareCollections() {
        if (this.soundCloudAwareCollections == null) {
            this.soundCloudAwareCollections = new ArrayList<String>();
            if (StringUtils.isNotBlank((String)this.soundCloudAwareCollectionsString)) {
                String[] items;
                for (String item : items = this.soundCloudAwareCollectionsString.split(",")) {
                    this.soundCloudAwareCollections.add(item.trim());
                }
            }
        }
        return this.soundCloudAwareCollections;
    }

    public List<String> getHierarchyRoots() {
        if (this.hierarchyRoots == null) {
            this.hierarchyRoots = new ArrayList<String>();
            if (StringUtils.isNotBlank((String)this.hierarchyRootsString)) {
                String[] items;
                for (String item : items = this.hierarchyRootsString.split(",")) {
                    this.hierarchyRoots.add(item.trim());
                }
            }
        }
        return this.hierarchyRoots;
    }

    public String getOptOutList() {
        return this.optOutList;
    }

    public String getSitemapCache() {
        return this.sitemapCache;
    }

    public int getApiRowLimit() {
        return this.apiRowLimit;
    }

    public double getWeightTitle() {
        return this.weightTitle;
    }

    public double getWeightWho() {
        return this.weightWho;
    }

    public double getWeightWhat() {
        return this.weightWhat;
    }

    public double getWeightProvider() {
        return this.weightProvider;
    }

    public double getWeightDataProvider() {
        return this.weightDataProvider;
    }

    public int getKeywordLanguagesLimit() {
        return this.keywordLanguagesLimit == null ? 6 : this.keywordLanguagesLimit;
    }

    public String getMyEuropeanaUrl() {
        return NEW_MYEUROPEANA_URL;
    }

    public boolean useBackendTranslation() {
        if (StringUtils.isBlank((String)this.useBackendItemTranslationString)) {
            return false;
        }
        return Boolean.parseBoolean(this.useBackendItemTranslationString);
    }

    public boolean isNofEnabled() {
        return this.nofEnabled;
    }

    public boolean useAutomatedFrontendTranslation() {
        if (StringUtils.isBlank((String)this.useAutomatedFrontendTranslationString)) {
            return false;
        }
        return Boolean.parseBoolean(this.useAutomatedFrontendTranslationString);
    }

    public String getBingTranslateId() {
        return this.bingTranslateId;
    }

    public String getSoundcloudClientID() {
        return this.soundcloudClientID;
    }

    public void setSoundcloudClientID(String soundcloudClientID) {
        this.soundcloudClientID = soundcloudClientID;
    }
}

