/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.service.impl;

import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.Token;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.exception.ProblemType;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.web.email.EmailBuilder;
import eu.europeana.corelib.web.exception.EmailServiceException;
import eu.europeana.corelib.web.service.EmailService;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public abstract class EmailServiceImpl
implements EmailService {
    @Log
    private Logger log;
    @Resource
    private JavaMailSender mailSender;
    @Resource
    private MessageSource messageSource;

    @Override
    public void sendToken(Token token, String url) throws EmailServiceException {
        if (token == null || StringUtils.isBlank((String)token.getToken()) || StringUtils.isBlank((String)token.getEmail()) || StringUtils.isBlank((String)url)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("token", token.getToken());
        model.put("url", url);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("register");
        builder.setEmailTo(token.getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        this.log.info(String.format("Sent token (%s) and URL (%s) to %s", token.getToken(), url, token.getEmail()));
    }

    @Override
    public void sendApiToken(Token token, String url) throws EmailServiceException {
        if (token == null || StringUtils.isBlank((String)token.getToken()) || StringUtils.isBlank((String)token.getEmail()) || StringUtils.isBlank((String)url)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("token", token.getToken());
        model.put("url", url);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("registerApi");
        builder.setEmailTo(token.getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        this.log.info(String.format("Sent token (%s) and URL (%s) to %s", token.getToken(), url, token.getEmail()));
    }

    @Override
    public void sendRegisterNotify(User user) throws EmailServiceException {
        if (user == null) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("registerNotify");
        this.mailSender.send((MimeMessagePreparator)builder);
        this.log.info(String.format("Sent user registratiom (%s)", user.getEmail()));
    }

    @Override
    public void sendRegisterApiNotifyAdmin(User user) throws EmailServiceException {
        if (user == null) {
            this.log.error("Problem with sendRegisterApiNotifyAdmin: user is null");
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("registerApiNotifyAdmin");
        this.mailSender.send((MimeMessagePreparator)builder);
        this.log.info(String.format("Sent notification of API registratiom (%s)", user.getEmail()));
    }

    @Override
    public void sendRegisterApiNotifyUser(ApiKey apiKey, Locale locale) throws EmailServiceException {
        String[] labels;
        if (apiKey == null) {
            this.log.error("Problem with sendRegisterApiNotifyUser: apiKey is null");
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("apiKey", apiKey);
        String prefix = "register_api_notify_user_";
        String suffix = "_t";
        for (String label : labels = new String[]{"line1", "line2", "apikey_label", "privatekey_label", "line3a", "line3b", "line4", "line5", "line6a", "line6b", "line7"}) {
            try {
                String value = this.messageSource.getMessage(prefix + label + suffix, null, locale);
                model.put(label, value);
                String html = value;
                if (StringUtils.contains((String)html, (String)"http://") || StringUtils.contains((String)html, (String)"https://")) {
                    html = html.replaceAll("(https?://[^ ,]+)", "<a href=\"$1\" target=\"_blank\">$1</a>");
                }
                if (StringUtils.contains((String)html, (String)"@")) {
                    html = html.replaceAll("([^ ,]+@[^ ,]+)", "<a href=\"mailto:$1\" target=\"_blank\">$1</a>");
                }
                model.put(label + "_html", html);
            }
            catch (NoSuchMessageException e) {
                this.log.error(String.format("Label %s is not defined", label));
            }
        }
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("registerApiNotifyUser");
        builder.setEmailTo(apiKey.getUser().getEmail());
        this.mailSender.send((MimeMessagePreparator)builder);
        this.log.info(String.format("Sent API details to %s", apiKey.getUser().getEmail()));
    }

    @Override
    public void sendForgotPassword(User user, String url) throws EmailServiceException {
        if (user == null || user.getId() == null || StringUtils.isBlank((String)url)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        this.sendForgotPassword(user.getEmail(), url);
    }

    @Override
    public void sendForgotPassword(String email, String url) throws EmailServiceException {
        if (StringUtils.isBlank((String)email) || StringUtils.isBlank((String)url)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", url);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("forgotPassword");
        builder.setEmailTo(email);
        this.mailSender.send((MimeMessagePreparator)builder);
        this.log.info(String.format("Sent forgot password (URL=%s) to %s", url, email));
    }

    @Override
    public void sendFeedback(String email, String feedback) throws EmailServiceException {
        if (StringUtils.isBlank((String)email) || StringUtils.isBlank((String)feedback)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("email", email);
        model.put("feedback", feedback);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("userFeedback");
        this.mailSender.send((MimeMessagePreparator)builder);
        builder.setTemplate("userFeedbackConfirm");
        builder.setEmailTo(email);
        this.mailSender.send((MimeMessagePreparator)builder);
        this.log.info(String.format("Sent feedback of %s", email));
    }

    @Override
    public void sendException(String subject, String body) throws EmailServiceException {
        if (StringUtils.isBlank((String)subject) || StringUtils.isBlank((String)body)) {
            throw new EmailServiceException(ProblemType.INVALIDARGUMENTS);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subject", subject);
        model.put("body", body);
        EmailBuilder builder = this.createEmailBuilder();
        builder.setModel(model);
        builder.setTemplate("exception");
        builder.setSubject(subject);
        this.mailSender.send((MimeMessagePreparator)builder);
    }

    protected abstract EmailBuilder createEmailBuilder();
}

