/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.web.interceptor;

import eu.europeana.corelib.definitions.exception.ProblemType;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.web.exception.WebConfigurationException;
import eu.europeana.corelib.web.model.PageData;
import eu.europeana.corelib.web.support.Configuration;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ConfigInterceptor
extends HandlerInterceptorAdapter {
    @Log
    private Logger log;
    @Resource
    private Configuration config;
    @Value(value="#{europeanaProperties['portal.indexable']}")
    private boolean indexable;
    @Value(value="#{europeanaProperties['portal.google.analytics.id']}")
    private String portalGoogleAnalyticsId;
    @Value(value="#{europeanaProperties['portal.google.maps.key']}")
    private String portalGoogleMapsId;
    @Value(value="#{europeanaProperties['portal.addthis.pubid']}")
    private String portalAddthisId;
    @Value(value="#{europeanaProperties['portal.sharethis.pubid']}")
    private String portalSharethisId;
    @Value(value="#{europeanaProperties['portal.facebook.appid']}")
    private String portalFacebookId;
    @Value(value="#{europeanaProperties['portal.bing.translate.key']}")
    private String portalBingTranslateId;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, o, modelAndView);
        if (modelAndView != null && !modelAndView.getViewName().startsWith("redirect:") && modelAndView.getModel().containsKey("model")) {
            PageData model = (PageData)modelAndView.getModel().get("model");
            StringBuilder currentUrl = new StringBuilder(this.config.getPortalServer());
            currentUrl.append(request.getRequestURI());
            if (request.getQueryString() != null) {
                currentUrl.append("?").append(request.getQueryString());
            }
            model.setCurrentUrl(currentUrl.toString().replace("portal/portal/", "portal/"));
            model.setDebug(this.config.getDebugMode());
            model.setIndexable(this.indexable);
            if (request.getParameterMap().containsKey("minify")) {
                model.setMinify(StringUtils.equals((String)"true", (String)request.getParameter("minify")));
            }
            model.setPortalServer(this.checkMandatoryValue(this.config.getPortalServer(), "portal.server"));
            model.setMetaCanonicalUrl(this.config.getCannonicalPortalServer());
            model.setCacheUrl(this.checkMandatoryValue(this.config.getImageCacheUrl(), "imageCacheUrl"));
            model.setGoogleAnalyticsId(StringUtils.trimToEmpty((String)this.portalGoogleAnalyticsId));
            model.setGoogleMapsId(StringUtils.trimToEmpty((String)this.portalGoogleMapsId));
            model.setAddThisId(StringUtils.trimToEmpty((String)this.portalAddthisId));
            model.setShareThisId(StringUtils.trimToEmpty((String)this.portalSharethisId));
            model.setFacebookId(StringUtils.trimToEmpty((String)this.portalFacebookId));
            model.setBingTranslateId(StringUtils.trimToEmpty((String)this.portalBingTranslateId));
        }
    }

    private String checkMandatoryValue(String value, String name) throws WebConfigurationException {
        if (StringUtils.isBlank((String)value)) {
            ProblemType problem = ProblemType.INVALIDARGUMENTS;
            if (StringUtils.isNotBlank((String)name)) {
                String message = "Inexisting property: " + name;
                this.log.error(message);
                problem.appendMessage(message);
            }
            throw new WebConfigurationException(problem);
        }
        return StringUtils.trim((String)value);
    }
}

