/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StringArrayUtils {
    public static final String[] EMPTY_ARRAY = new String[0];

    public static boolean isNotBlank(String[] array) {
        return array != null && array.length > 0 && StringUtils.join((Object[])array).trim().length() > 0;
    }

    public static boolean isNotBlankList(List<String> array) {
        return array != null && array.size() > 0 && StringUtils.join(array, (String)"").trim().length() > 0;
    }

    public static boolean isBlank(String[] array) {
        return !StringArrayUtils.isNotBlank(array);
    }

    public static String[] toArray(List<String> list) {
        if (list != null && list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return EMPTY_ARRAY;
    }

    public static List<String> toList(String ... items) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringArrayUtils.isNotBlank(items)) {
            for (String s : items) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                list.add(s);
            }
        }
        return list;
    }

    public static Set<String> toSet(String ... items) {
        HashSet<String> list = new HashSet<String>();
        if (StringArrayUtils.isNotBlank(items)) {
            for (String s : items) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                list.add(s);
            }
        }
        return list;
    }

    public static String[] toArray(String ... items) {
        return items;
    }

    public static void addToList(List<String> list, String[] toAdd) {
        if (list != null && StringArrayUtils.isNotBlank(toAdd)) {
            for (String string : toAdd) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                list.add(string);
            }
        }
    }

    public static String formatList(String[] items) {
        if (StringArrayUtils.isNotBlank(items)) {
            if (items.length == 1) {
                return StringUtils.trim((String)items[0]);
            }
            StringBuilder sb = new StringBuilder();
            for (String item : items) {
                if (sb.length() > 0) {
                    sb.append("| ");
                }
                sb.append(StringUtils.trim((String)item));
            }
            int p = sb.lastIndexOf("|");
            if (p > 0) {
                sb.replace(p, p + 1, " &");
            }
            return sb.toString().replace("|", ",");
        }
        return "";
    }

    public static String[] addToArray(String[] items, String str) {
        ArrayList<Object> itemList = items == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(items));
        if (str != null) {
            itemList.add(str);
        }
        return itemList.toArray(new String[itemList.size()]);
    }

    public static String concat(String ... strings) {
        if (StringArrayUtils.isNotBlank(strings)) {
            StringBuilder sb = new StringBuilder();
            for (String string : strings) {
                sb.append(string);
            }
            return sb.toString();
        }
        return null;
    }

    public static String clean(String s) {
        if (StringUtils.isNotEmpty((String)(s = StringUtils.trim((String)s)))) {
            String regex = "\\s{2,}";
            s = s.replaceAll(regex, " ");
        }
        return s;
    }

    public static String[] splitWebParameter(String[] array) {
        if (StringArrayUtils.isBlank(array)) {
            return EMPTY_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String item : array) {
            if (!StringUtils.isNotBlank((String)item)) continue;
            String[] items = StringUtils.split((String)item, (String)" +,");
            StringArrayUtils.addToList(result, items);
        }
        return StringArrayUtils.toArray(result);
    }
}

