/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class EuropeanaUriUtils {
    private static final String REPLACEMENT = "_";

    private EuropeanaUriUtils() {
    }

    public static String createSanitizedEuropeanaId(String collectionId, String recordId) {
        return "/" + EuropeanaUriUtils.sanitizeCollectionId(collectionId) + "/" + EuropeanaUriUtils.sanitizeRecordId(recordId);
    }

    public static String createEuropeanaId(String collectionId, String recordId) {
        return "/" + collectionId + "/" + recordId;
    }

    private static String sanitizeRecordId(String recordId) {
        recordId = StringUtils.startsWith((String)recordId, (String)"http://") ? StringUtils.substringAfter((String)StringUtils.substringAfter((String)recordId, (String)"http://"), (String)"/") : recordId;
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9_]");
        Matcher matcher = pattern.matcher(recordId);
        recordId = matcher.replaceAll(REPLACEMENT);
        return recordId;
    }

    private static String sanitizeCollectionId(String collectionId) {
        Pattern pattern = Pattern.compile("[a-zA-Z]");
        Matcher matcher = pattern.matcher(collectionId.substring(collectionId.length() - 1, collectionId.length()));
        return matcher.find() ? StringUtils.substring((String)collectionId, (int)0, (int)(collectionId.length() - 1)) : collectionId;
    }

    public static String encode(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }

    public static String decode(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }
}

