/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.utils;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;

public class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage scale(BufferedImage org, int width, int height) throws IOException {
        if (org != null) {
            BufferedImage resized = Scalr.resize((BufferedImage)org, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            if (resized.getHeight() > height || resized.getWidth() > width) {
                return Scalr.crop((BufferedImage)resized, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
            }
            return resized;
        }
        return null;
    }

    public static byte[] toByteArray(BufferedImage org) throws IOException {
        if (org != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)org, "jpg", baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            return imageInByte;
        }
        return null;
    }

    public static BufferedImage toBufferedImage(byte[] org) throws IOException {
        if (org == null || org.length == 0) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(org);
        return ImageIO.read(in);
    }
}

