/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateUtils {
    private static final Logger LOG = LogManager.getLogger(DateUtils.class);
    private static final SimpleDateFormat DATE_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeFormatter ISO_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);

    private DateUtils() {
    }

    public static Date clone(Date date) {
        if (date != null) {
            return new Date(date.getTime());
        }
        return null;
    }

    public static String format(Date date) {
        return DATE_TIME_FORMATTER.format(date);
    }

    public static Date parse(String date) {
        if (StringUtils.isNotEmpty((CharSequence)date)) {
            try {
                return DATE_TIME_FORMATTER.parse(date);
            }
            catch (ParseException e) {
                LOG.warn(e.getMessage());
            }
        }
        return null;
    }

    public static boolean isYear(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                Year year = Year.of(Integer.parseInt(value));
                return year != null;
            }
            catch (NumberFormatException | DateTimeException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isYearRange(String value) {
        String[] years;
        if (StringUtils.isNotEmpty((CharSequence)value) && (years = value.split("-")).length == 2) {
            try {
                return Year.parse(years[0]).isBefore(Year.parse(years[1]));
            }
            catch (DateTimeException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isIsoDate(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                TemporalAccessor tmp = ISO_DATE_FORMATTER.parse(value);
                return tmp != null;
            }
            catch (DateTimeException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isIsoDateTime(String value) {
        return DateUtils.parse(value) != null;
    }

    static {
        DATE_TIME_FORMATTER.setTimeZone(TimeZone.getTimeZone("GTM"));
    }
}

