/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class ComparatorUtils
implements Comparator<String> {
    private static final String PUNCTUATION_REGEX = "[\\p{Punct}]+";

    public static String stripPunctuation(String value) {
        return value.replaceAll(PUNCTUATION_REGEX, "");
    }

    public static List<String> stripPunctuations(List<String> list) {
        ArrayList<String> listWithoutPunctuation = new ArrayList<String>();
        for (String value : list) {
            listWithoutPunctuation.add(ComparatorUtils.stripPunctuation(value));
        }
        return listWithoutPunctuation;
    }

    public static List<String> removeDuplicates(List<String> listWithDuplicates) {
        TreeSet<String> set = new TreeSet<String>(new ComparatorUtils());
        set.addAll(listWithDuplicates);
        listWithDuplicates.clear();
        listWithDuplicates.addAll(set);
        return listWithDuplicates;
    }

    @Override
    public int compare(String o1, String o2) {
        if (ComparatorUtils.stripPunctuation(o1).equalsIgnoreCase(ComparatorUtils.stripPunctuation(o2))) {
            return 0;
        }
        return 1;
    }
}

