/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.uim.sugarcrmclient.internal.helpers;

import eu.europeana.uim.sugarcrmclient.enums.EuropeanaDatasetStates;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaOrgRole;
import eu.europeana.uim.sugarcrmclient.internal.helpers.SugarCRMNamespaceContext;
import eu.europeana.uim.sugarcrmclient.jibxbindings.Array;
import eu.europeana.uim.sugarcrmclient.jibxbindings.ArrayAttributes;
import eu.europeana.uim.sugarcrmclient.jibxbindings.CommonAttributes;
import eu.europeana.uim.sugarcrmclient.jibxbindings.Login;
import eu.europeana.uim.sugarcrmclient.jibxbindings.NameValue;
import eu.europeana.uim.sugarcrmclient.jibxbindings.NameValueList;
import eu.europeana.uim.sugarcrmclient.jibxbindings.SelectFields;
import eu.europeana.uim.sugarcrmclient.jibxbindings.UserAuth;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
public class ClientUtils {
    private static Logger logger = Logger.getLogger(ClientUtils.class);
    private static Map<String, Map<String, String>> translateMap;

    private ClientUtils() {
    }

    public static void logMarshalledObject(Object jibxObject) {
        try {
            String xmlContent = ClientUtils.unmarshallObject(jibxObject);
            logger.info((Object)"===========================================");
            StringBuffer sb = new StringBuffer("Soap Ouput for Class: ");
            sb.append(jibxObject.getClass().getSimpleName());
            logger.info((Object)sb.toString());
            logger.info((Object)xmlContent);
            logger.info((Object)"===========================================");
        }
        catch (JiBXException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static void logMarshalledObjectOsgi(PrintStream out, Object jibxObject) {
        try {
            String xmlContent = ClientUtils.unmarshallObject(jibxObject);
            out.println("===========================================");
            StringBuffer sb = new StringBuffer("Soap Ouput for Class: ");
            sb.append(jibxObject.getClass().getSimpleName());
            out.println(sb.toString());
            out.println(xmlContent);
            out.println("===========================================");
        }
        catch (JiBXException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static String unmarshallObject(Object jibxObject) throws JiBXException {
        IBindingFactory context = BindingDirectory.getFactory(jibxObject.getClass());
        IMarshallingContext mctx = context.createMarshallingContext();
        mctx.setIndent(2);
        StringWriter stringWriter = new StringWriter();
        mctx.setOutput((Writer)stringWriter);
        mctx.marshalDocument(jibxObject);
        String xmlContents = stringWriter.toString();
        return xmlContents;
    }

    public static String md5(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(value.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Login createStandardLoginObject(String username, String passwrd) {
        Login login = new Login();
        UserAuth user = new UserAuth();
        user.setUserName(username);
        user.setPassword(ClientUtils.md5(passwrd));
        user.setVersion("1.0");
        login.setApplicationName("EuropeanaSugarCRMClient");
        login.setUserAuth(user);
        return login;
    }

    public static SelectFields generatePopulatedSelectFields(List<String> fieldnames) {
        SelectFields selfields = new SelectFields();
        StringBuffer arrayType = new StringBuffer();
        arrayType.append("string[");
        arrayType.append(fieldnames.size());
        arrayType.append("]");
        CommonAttributes commonAttributes = new CommonAttributes();
        commonAttributes.setHref(arrayType.toString());
        selfields.setCommonAttributes(commonAttributes);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            for (String fieldname : fieldnames) {
                Element element = document.createElement("string");
                Array array = new Array();
                array.getAnyList();
                selfields.setArray(array);
                element.appendChild(document.createTextNode(fieldname));
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        return selfields;
    }

    public static NameValueList generatePopulatedNameValueList(List<NameValue> namevalues) {
        NameValueList namevalueList = new NameValueList();
        StringBuffer arrayType = new StringBuffer();
        arrayType.append("name_value[");
        arrayType.append(namevalues.size());
        arrayType.append("]");
        Array array = new Array();
        ArrayAttributes.ArrayType arrTypeObj = new ArrayAttributes.ArrayType();
        arrTypeObj.setArrayType(arrayType.toString());
        ArrayAttributes atts = new ArrayAttributes();
        atts.setArrayType(arrTypeObj);
        namevalueList.setArrayAttributes(atts);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            for (NameValue namevalue : namevalues) {
                Element name_value = document.createElement("name_value");
                Element name = document.createElement("name");
                Element value = document.createElement("value");
                name.appendChild(document.createTextNode(namevalue.getName()));
                value.appendChild(document.createTextNode(namevalue.getValue()));
                name_value.appendChild(name);
                name_value.appendChild(value);
                array.getAnyList().add(name_value);
            }
            namevalueList.setArray(array);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        return namevalueList;
    }

    public static HashMap<String, HashMap<String, String>> responseFactory(String responseString) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        HashMap<String, HashMap<String, String>> returnMap = new HashMap<String, HashMap<String, String>>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(responseString)));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new SugarCRMNamespaceContext());
        XPathExpression expr = xpath.compile("//ns1:get_entry_listResponse/return/entry_list/item");
        Object result = expr.evaluate(document, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            NodeList innerNodes = nodes.item(i).getChildNodes();
            String id = innerNodes.item(0).getTextContent();
            HashMap<String, String> elementData = new HashMap<String, String>();
            NodeList infoNodes = innerNodes.item(2).getChildNodes();
            for (int z = 0; z < infoNodes.getLength(); ++z) {
                String name = infoNodes.item(z).getFirstChild().getTextContent();
                String value = infoNodes.item(z).getLastChild().getTextContent();
                elementData.put(name, value);
            }
            returnMap.put(id, elementData);
        }
        return returnMap;
    }

    public static String extractSimpleResponse(String responseString) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(responseString)));
            String sessionID = null;
            NodeList nl = document.getElementsByTagName("id");
            if (nl.getLength() > 0) {
                sessionID = nl.item(0).getTextContent();
            }
            return sessionID;
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SAXException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static String extractFromElement(String value, Element el) {
        NodeList nl = el.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            String textcontent = nd.getChildNodes().item(0).getTextContent();
            if (!value.equals(textcontent)) continue;
            return nd.getChildNodes().item(1).getTextContent();
        }
        return null;
    }

    public static Map<String, String> mapFromElement(Element el) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        NodeList nl = el.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            String id = nd.getChildNodes().item(0).getTextContent();
            String content = nd.getChildNodes().item(1).getTextContent();
            retMap.put(id, content);
        }
        return retMap;
    }

    public static String translateStatus(String sugarcrmStatusStr) {
        if (translateMap == null) {
            ClientUtils.setUpDatasetStates();
        }
        if (sugarcrmStatusStr != null) {
            sugarcrmStatusStr = sugarcrmStatusStr.replace(" ", "%");
            if (translateMap.get("sys2desc").containsKey(sugarcrmStatusStr)) {
                return translateMap.get("sys2desc").get(sugarcrmStatusStr);
            }
            return "Unknown State";
        }
        return "No State Defined";
    }

    public static String translateDsStatusDescription(String description) {
        if (translateMap == null) {
            ClientUtils.setUpDatasetStates();
        }
        if (StringUtils.isNotBlank((String)description) && translateMap.get("desc2sys").containsKey(description)) {
            return translateMap.get("desc2sys").get(description).replace("%", " ");
        }
        return null;
    }

    private static void setUpDatasetStates() {
        if (translateMap == null) {
            translateMap = new HashMap<String, Map<String, String>>();
            translateMap.put("sys2desc", new HashMap());
            translateMap.put("desc2sys", new HashMap());
        }
        for (EuropeanaDatasetStates e : EuropeanaDatasetStates.values()) {
            translateMap.get("sys2desc").put(e.getSysId(), e.getDescription());
            translateMap.get("desc2sys").put(e.getDescription(), e.getSysId());
        }
    }

    public static String translateType(String provtype) {
        if (provtype != null) {
            EuropeanaOrgRole actualvalue = null;
            for (EuropeanaOrgRole e : EuropeanaOrgRole.values()) {
                if (!e.getSysId().equals(provtype)) continue;
                actualvalue = e;
            }
            if (actualvalue != null) {
                return actualvalue.getDescription();
            }
            return "Unknown Type";
        }
        return "Undefined";
    }
}

