/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.uim.sugarcrmclient.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapMessageCreationException;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.transport.TransportInputStream;

public class ExtendedSaajSoapMessageFactory
extends SaajSoapMessageFactory {
    public ExtendedSaajSoapMessageFactory() {
    }

    public ExtendedSaajSoapMessageFactory(MessageFactory messageFactory) {
        super.setMessageFactory(messageFactory);
    }

    public SaajSoapMessage createWebServiceMessage(InputStream inputStream) throws IOException {
        MimeHeaders mimeHeaders = this.parseMimeHeaders(inputStream);
        try {
            inputStream = this.checkForUtf8ByteOrderMark(inputStream);
            inputStream = ExtendedSaajSoapMessageFactory.decompressStream((PushbackInputStream)inputStream);
            return new SaajSoapMessage(this.getMessageFactory().createMessage(mimeHeaders, inputStream));
        }
        catch (SOAPException ex) {
            String contentType = StringUtils.arrayToCommaDelimitedString((Object[])mimeHeaders.getHeader("Content-Type"));
            if (contentType.indexOf("startinfo") != -1) {
                contentType = contentType.replace("startinfo", "start-info");
                mimeHeaders.setHeader("Content-Type", contentType);
                try {
                    return new SaajSoapMessage(this.getMessageFactory().createMessage(mimeHeaders, inputStream), true);
                }
                catch (SOAPException e) {
                    // empty catch block
                }
            }
            throw new SoapMessageCreationException("Could not create message from InputStream: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private MimeHeaders parseMimeHeaders(InputStream inputStream) throws IOException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        if (inputStream instanceof TransportInputStream) {
            TransportInputStream transportInputStream = (TransportInputStream)inputStream;
            Iterator headerNames = transportInputStream.getHeaderNames();
            while (headerNames.hasNext()) {
                String headerName = (String)headerNames.next();
                Iterator headerValues = transportInputStream.getHeaders(headerName);
                while (headerValues.hasNext()) {
                    String headerValue = (String)headerValues.next();
                    StringTokenizer tokenizer = new StringTokenizer(headerValue, ",");
                    while (tokenizer.hasMoreTokens()) {
                        mimeHeaders.addHeader(headerName, tokenizer.nextToken().trim());
                    }
                }
            }
        }
        return mimeHeaders;
    }

    private InputStream checkForUtf8ByteOrderMark(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }

    public static InputStream decompressStream(PushbackInputStream pb) throws IOException {
        byte[] signature = new byte[2];
        pb.read(signature);
        pb.unread(signature);
        if (signature[0] == 31 && signature[1] == -117) {
            return new GZIPInputStream(pb);
        }
        return pb;
    }
}

