/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils.queryextractor;

import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.solr.utils.SimpleAnalyzer;
import eu.europeana.corelib.solr.utils.queryextractor.QueryModification;
import eu.europeana.corelib.solr.utils.queryextractor.QueryTermPosition;
import eu.europeana.corelib.solr.utils.queryextractor.QueryToken;
import eu.europeana.corelib.solr.utils.queryextractor.QueryType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.Version;

public class QueryExtractor {
    private Logger log = Logger.getLogger((String)QueryExtractor.class.getCanonicalName());
    private static Analyzer analyzer = new SimpleAnalyzer();
    private static QueryParser queryParser = new QueryParser(Version.LUCENE_40, "text", analyzer);
    private List<QueryToken> queryTokens = new ArrayList<QueryToken>();
    private int group = 0;
    private String rawQueryString;

    public QueryExtractor(String rawQueryString) {
        this.rawQueryString = rawQueryString;
    }

    public List<String> extractTerms() {
        return this.extractTerms(false);
    }

    public List<String> extractTerms(boolean byGroups) {
        ArrayList<String> terms = new ArrayList<String>();
        for (QueryToken token : this.extractInfo(byGroups)) {
            terms.add(token.getPosition() == null ? token.getNormalizedQueryTerm() : token.getPosition().getOriginal());
        }
        return terms;
    }

    public List<QueryToken> extractInfo(boolean byGroups) {
        this.parseQuery();
        List<QueryToken> queryTerms = byGroups ? this.getTermsByGroups() : this.queryTokens;
        return queryTerms;
    }

    public String rewrite(List<QueryModification> modifications) {
        boolean[] mask = new boolean[this.rawQueryString.length()];
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = modifications.size() - 1; i >= 0; --i) {
            QueryModification modification = modifications.get(i);
            if (modification == null) continue;
            for (int j = modification.getStart(); j < modification.getEnd(); ++j) {
                mask[j] = true;
            }
            map.put(modification.getStart(), modification.getModification());
        }
        String rewritten = "";
        boolean lastValue = false;
        for (int i = 0; i < mask.length; ++i) {
            if (!mask[i]) {
                rewritten = rewritten + this.rawQueryString.substring(i, i + 1);
            } else if (!lastValue) {
                rewritten = rewritten + (String)map.get(i);
            }
            lastValue = mask[i];
        }
        return rewritten;
    }

    private void parseQuery() {
        List<QueryTermPosition> termPositions = this.extractTokens(this.rawQueryString);
        Query query = null;
        try {
            query = queryParser.parse(this.rawQueryString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Stack<QueryType> queryTypeStack = new Stack<QueryType>();
        this.deconstructQuery(query, queryTypeStack);
        this.insertPositions(termPositions);
    }

    private List<QueryToken> getTermsByGroups() {
        ArrayList<QueryToken> queryTerms = new ArrayList<QueryToken>();
        for (QueryToken token : this.queryTokens) {
            if (queryTerms.size() == 0 || token.getType().equals((Object)QueryType.TERMRANGE)) {
                queryTerms.add(token);
                continue;
            }
            int lastIndex = queryTerms.size() - 1;
            QueryToken prevToken = (QueryToken)queryTerms.get(lastIndex);
            if (prevToken.getGroup() == token.getGroup()) {
                try {
                    QueryToken mergedToken = prevToken.clone();
                    mergedToken.merge(token, this.rawQueryString);
                    if (!(mergedToken.getPosition().getOriginal().contains(" AND ") || mergedToken.getPosition().getOriginal().contains(" OR ") || mergedToken.getPosition().getOriginal().contains(" NOT "))) {
                        queryTerms.set(lastIndex, mergedToken);
                        continue;
                    }
                    queryTerms.add(token);
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            queryTerms.add(token);
        }
        return queryTerms;
    }

    private void insertPositions(List<QueryTermPosition> termPositions) {
        int i = 0;
        int lastFoundPosition = -1;
        int max = termPositions.size();
        for (QueryToken token : this.queryTokens) {
            boolean isPhrase = token.getType().equals((Object)QueryType.PHRASE);
            ArrayList<QueryTermPosition> bag = new ArrayList<QueryTermPosition>();
            String foundPart = "";
            boolean success = false;
            for (i = lastFoundPosition + 1; i < max; ++i) {
                QueryTermPosition position = termPositions.get(i);
                if (isPhrase) {
                    String candidate;
                    String string = candidate = foundPart.equals("") ? position.getTransformed() : foundPart + " " + position.getTransformed();
                    if (token.getNormalizedQueryTerm().equals(candidate)) {
                        bag.add(position);
                        success = true;
                        foundPart = candidate;
                        lastFoundPosition = i;
                        break;
                    }
                    if (!token.getNormalizedQueryTerm().startsWith(candidate)) continue;
                    bag.add(position);
                    foundPart = candidate;
                    continue;
                }
                if (!token.getNormalizedQueryTerm().equals(position.getTransformed())) continue;
                token.setPosition(position);
                lastFoundPosition = i;
                if (token.getType().equals((Object)QueryType.TERM) && position.getStart() > 0 && position.getEnd() < this.rawQueryString.length() && this.rawQueryString.substring(position.getStart() - 1, position.getStart()).equals("\"") && this.rawQueryString.substring(position.getEnd(), position.getEnd() + 1).equals("\"")) {
                    token.getTypeStack().pop();
                    token.getTypeStack().add(QueryType.PHRASE);
                }
                success = true;
                break;
            }
            if (success) {
                if (!isPhrase) continue;
                int start = ((QueryTermPosition)bag.get(0)).getStart();
                int end = ((QueryTermPosition)bag.get(bag.size() - 1)).getEnd();
                int pos = ((QueryTermPosition)bag.get(0)).getPosition();
                String original = this.rawQueryString.substring(start, end);
                token.setPosition(new QueryTermPosition(start, end, foundPart, original, pos));
                continue;
            }
            this.log.debug("token not found for: " + token.getNormalizedQueryTerm());
        }
    }

    public boolean deconstructQuery(Query query, Stack<QueryType> queryTypeStack) {
        if (query == null) {
            return true;
        }
        if (query instanceof TermQuery) {
            queryTypeStack.add(QueryType.TERM);
            this.deconstructTermQuery((TermQuery)query, queryTypeStack);
        } else if (query instanceof PhraseQuery) {
            ++this.group;
            queryTypeStack.add(QueryType.PHRASE);
            this.deconstructPhraseQuery((PhraseQuery)query, queryTypeStack);
        } else if (query instanceof BooleanQuery) {
            ++this.group;
            queryTypeStack.add(QueryType.BOOLEAN);
            this.deconstructBooleanQuery((BooleanQuery)query, queryTypeStack);
        } else if (query instanceof PrefixQuery) {
            ++this.group;
            queryTypeStack.add(QueryType.PREFIX);
            this.deconstructPrefixQuery((PrefixQuery)query, queryTypeStack);
        } else if (query instanceof FuzzyQuery) {
            ++this.group;
            queryTypeStack.add(QueryType.FUZZY);
            this.deconstructFuzzyQuery((FuzzyQuery)query, queryTypeStack);
        } else if (query instanceof TermRangeQuery) {
            ++this.group;
            queryTypeStack.add(QueryType.TERMRANGE);
            this.deconstructTermRangeQuery((TermRangeQuery)query, queryTypeStack);
        } else if (query instanceof MatchAllDocsQuery) {
            ++this.group;
            queryTypeStack.add(QueryType.MATCHALLDOCS);
            this.deconstructMatchAllDocsQuery((MatchAllDocsQuery)query, queryTypeStack);
        } else {
            this.log.warning("Unhandled query class: " + query.getClass());
        }
        if (queryTypeStack.size() > 0) {
            queryTypeStack.pop();
        }
        return true;
    }

    private void deconstructPhraseQuery(PhraseQuery query, Stack<QueryType> queryTypeStack) {
        int[] positions = query.getPositions();
        Term[] terms = query.getTerms();
        ArrayList<String> words = new ArrayList<String>();
        int m = positions.length;
        for (int i = 0; i < m; ++i) {
            words.add(terms[i].text());
        }
        String term = StringUtils.join(words, (String)" ");
        this.queryTokens.add(new QueryToken(term, queryTypeStack, this.group));
    }

    private void deconstructTermRangeQuery(TermRangeQuery query, Stack<QueryType> queryTypeStack) {
        this.queryTokens.add(new QueryToken(query.getLowerTerm().utf8ToString(), queryTypeStack, this.group));
        this.queryTokens.add(new QueryToken(query.getUpperTerm().utf8ToString(), queryTypeStack, this.group));
    }

    private void deconstructFuzzyQuery(FuzzyQuery query, Stack<QueryType> queryTypeStack) {
        this.queryTokens.add(new QueryToken(query.getTerm().text(), queryTypeStack, this.group));
    }

    private void deconstructPrefixQuery(PrefixQuery query, Stack<QueryType> queryTypeStack) {
        this.queryTokens.add(new QueryToken(query.getPrefix().text(), queryTypeStack, this.group));
    }

    private void deconstructMatchAllDocsQuery(MatchAllDocsQuery query, Stack<QueryType> queryTypeStack) {
    }

    private void deconstructBooleanQuery(BooleanQuery query, Stack<QueryType> queryTypeStack) {
        BooleanClause.Occur prevOccur = null;
        for (BooleanClause clause : query.clauses()) {
            if (prevOccur != clause.getOccur()) {
                ++this.group;
            }
            queryTypeStack.pop();
            queryTypeStack.add(this.resolveOccur(clause.getOccur().name()));
            this.deconstructQuery(clause.getQuery(), queryTypeStack);
            prevOccur = clause.getOccur();
        }
    }

    private QueryType resolveOccur(String name) {
        switch (name) {
            case "AND": {
                return QueryType.BOOLEAN_AND;
            }
            case "OR": {
                return QueryType.BOOLEAN_OR;
            }
            case "NOT": {
                return QueryType.BOOLEAN_NOT;
            }
        }
        return QueryType.BOOLEAN;
    }

    private void deconstructTermQuery(TermQuery query, Stack<QueryType> queryTypeStack) {
        this.queryTokens.add(new QueryToken(query.getTerm().text(), queryTypeStack, this.group));
    }

    private List<QueryTermPosition> extractTokens(String text) {
        ArrayList<QueryTermPosition> queryTerms = new ArrayList<QueryTermPosition>();
        try {
            TokenStream ts = analyzer.tokenStream("text", (Reader)new StringReader(text));
            OffsetAttribute offsetAttribute = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            CharTermAttribute charTermAttribute = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            int i = 0;
            while (ts.incrementToken()) {
                int start = offsetAttribute.startOffset();
                int end = offsetAttribute.endOffset();
                String term = charTermAttribute.toString();
                queryTerms.add(new QueryTermPosition(start, end, term, text.substring(start, end), i++));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return queryTerms;
    }

    static {
        queryParser.setDefaultOperator(QueryParser.Operator.AND);
    }
}

