/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils.construct;

import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.definitions.solr.entity.Agent;
import eu.europeana.corelib.definitions.solr.entity.Aggregation;
import eu.europeana.corelib.definitions.solr.entity.Concept;
import eu.europeana.corelib.definitions.solr.entity.License;
import eu.europeana.corelib.definitions.solr.entity.Place;
import eu.europeana.corelib.definitions.solr.entity.Proxy;
import eu.europeana.corelib.definitions.solr.entity.Timespan;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.entity.LicenseImpl;
import eu.europeana.corelib.solr.utils.construct.AgentSolrCreator;
import eu.europeana.corelib.solr.utils.construct.AggregationSolrCreator;
import eu.europeana.corelib.solr.utils.construct.ConceptSolrCreator;
import eu.europeana.corelib.solr.utils.construct.EuropeanaAggregationSolrCreator;
import eu.europeana.corelib.solr.utils.construct.LicenseSolrCreator;
import eu.europeana.corelib.solr.utils.construct.PlaceSolrCreator;
import eu.europeana.corelib.solr.utils.construct.ProvidedChoSolrCreator;
import eu.europeana.corelib.solr.utils.construct.ProxySolrCreator;
import eu.europeana.corelib.solr.utils.construct.TimespanSolrCreator;
import eu.europeana.publication.common.ICollection;
import eu.europeana.publication.common.IDocument;
import eu.europeana.publication.common.State;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.common.SolrInputDocument;

public class SolrDocumentHandler
implements ICollection {
    private HttpSolrServer solrServer;

    public SolrDocumentHandler(HttpSolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public void save(FullBeanImpl fBean) {
        SolrInputDocument doc = new SolrInputDocument();
        List<LicenseImpl> licenses = fBean.getLicenses();
        ArrayList<String> licIds = new ArrayList<String>();
        if (licenses.size() > 0) {
            for (LicenseImpl licenseImpl : licenses) {
                licIds.add(licenseImpl.getAbout());
            }
        }
        new ProvidedChoSolrCreator().create(doc, fBean.getProvidedCHOs().get(0));
        new AggregationSolrCreator().create(doc, fBean.getAggregations().get(0), licIds);
        new EuropeanaAggregationSolrCreator().create(doc, fBean.getEuropeanaAggregation());
        for (Proxy proxy : fBean.getProxies()) {
            new ProxySolrCreator().create(doc, proxy);
        }
        for (Concept concept : fBean.getConcepts()) {
            new ConceptSolrCreator().create(doc, concept);
        }
        for (Timespan timespan : fBean.getTimespans()) {
            new TimespanSolrCreator().create(doc, timespan);
        }
        for (Agent agent : fBean.getAgents()) {
            new AgentSolrCreator().create(doc, agent);
        }
        for (Place place : fBean.getPlaces()) {
            new PlaceSolrCreator().create(doc, place);
        }
        for (License license : fBean.getLicenses()) {
            boolean isAggregation = false;
            for (Aggregation aggregation : fBean.getAggregations()) {
                if (aggregation.getEdmRights() == null || !((List)aggregation.getEdmRights().get("def")).contains(license.getAbout())) continue;
                isAggregation = true;
                break;
            }
            System.out.println(isAggregation);
            new LicenseSolrCreator().create(doc, license, isAggregation);
        }
        doc.addField(EdmLabel.EUROPEANA_COMPLETENESS.toString(), (Object)fBean.getEuropeanaCompleteness());
        doc.addField(EdmLabel.EUROPEANA_COLLECTIONNAME.toString(), (Object)fBean.getEuropeanaCollectionName()[0]);
        doc.addField("timestamp_created", (Object)fBean.getTimestampCreated());
        doc.addField("timestamp_update", (Object)fBean.getTimestampUpdated());
        try {
            this.solrServer.add(doc);
        }
        catch (SolrServerException ex) {
            Logger.getLogger(SolrDocumentHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SolrDocumentHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List<IDocument> getDocumentsByStatesUsingBatch(List<State> stateVlues, Map<String, List<String>> queryChoices, int batchSize) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IDocument getDocumentById(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void insertDocument(IDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateDocumentUsingId(IDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cloneDocument(IDocument originalDocument, IDocument clonedDocument) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteDocument(IDocument id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void commit() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

