/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils.construct;

import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.definitions.solr.entity.Place;
import eu.europeana.corelib.solr.utils.SolrUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.common.SolrInputDocument;

public class PlaceSolrCreator {
    public void create(SolrInputDocument doc, Place place) {
        Collection<Float> values;
        SolrUtils.addFromString(doc, EdmLabel.EDM_PLACE, place.getAbout());
        SolrUtils.addFromMap(doc, EdmLabel.PL_SKOS_PREF_LABEL, place.getPrefLabel());
        SolrUtils.addFromMap(doc, EdmLabel.PL_SKOS_ALT_LABEL, place.getAltLabel());
        SolrUtils.addFromMap(doc, EdmLabel.PL_SKOS_NOTE, place.getNote());
        SolrUtils.addFromMap(doc, EdmLabel.PL_SKOS_HIDDENLABEL, place.getHiddenLabel());
        SolrUtils.addFromStringArray(doc, EdmLabel.PL_OWL_SAMEAS, place.getOwlSameAs());
        SolrUtils.addFromMap(doc, EdmLabel.PL_DCTERMS_HASPART, place.getDcTermsHasPart());
        SolrUtils.addFromMap(doc, EdmLabel.PL_DCTERMS_ISPART_OF, place.getIsPartOf());
        if (place.getLatitude() != null && place.getLatitude().floatValue() != 0.0f) {
            values = doc.getFieldValues(EdmLabel.PL_WGS84_POS_LAT.toString());
            if (values == null) {
                values = new ArrayList<Float>();
            }
            values.add(place.getLatitude());
            doc.setField(EdmLabel.PL_WGS84_POS_LAT.toString(), values);
        }
        if (place.getLongitude() != null && place.getLongitude().floatValue() != 0.0f) {
            values = doc.getFieldValues(EdmLabel.PL_WGS84_POS_LONG.toString());
            if (values == null) {
                values = new ArrayList();
            }
            values.add(place.getLongitude());
            doc.setField(EdmLabel.PL_WGS84_POS_LONG.toString(), values);
        }
        if (place.getAltitude() != null && place.getAltitude().floatValue() != 0.0f) {
            values = doc.getFieldValues(EdmLabel.PL_WGS84_POS_ALT.toString());
            if (values == null) {
                values = new ArrayList();
            }
            values.add(place.getAltitude());
            doc.setField(EdmLabel.PL_WGS84_POS_ALT.toString(), values);
        }
    }
}

