/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils.construct;

import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import eu.europeana.corelib.definitions.jibx.ProvidedCHOType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.AggregationImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.corelib.solr.entity.EuropeanaAggregationImpl;
import eu.europeana.corelib.solr.entity.LicenseImpl;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.corelib.solr.entity.ProvidedCHOImpl;
import eu.europeana.corelib.solr.entity.ProxyImpl;
import eu.europeana.corelib.solr.entity.TimespanImpl;
import eu.europeana.corelib.solr.exceptions.MongoDBException;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.construct.AgentUpdater;
import eu.europeana.corelib.solr.utils.construct.AggregationUpdater;
import eu.europeana.corelib.solr.utils.construct.ConceptUpdater;
import eu.europeana.corelib.solr.utils.construct.EuropeanaAggregationUpdater;
import eu.europeana.corelib.solr.utils.construct.LicenseUpdater;
import eu.europeana.corelib.solr.utils.construct.PlaceUpdater;
import eu.europeana.corelib.solr.utils.construct.ProvidedChoUpdater;
import eu.europeana.corelib.solr.utils.construct.ProxyUpdater;
import eu.europeana.corelib.solr.utils.construct.TimespanUpdater;
import eu.europeana.publication.common.ICollection;
import eu.europeana.publication.common.IDocument;
import eu.europeana.publication.common.State;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.util.ClientUtils;

public class FullBeanHandler
implements ICollection {
    private EdmMongoServer mongoServer;
    Logger log = Logger.getLogger(this.getClass().getName());

    public FullBeanHandler(EdmMongoServer mongoServer) {
        this.mongoServer = mongoServer;
    }

    public boolean removeRecord(HttpSolrServer solrServer, RDF rdf) {
        try {
            solrServer.deleteByQuery("europeana_id:" + ClientUtils.escapeQueryChars((String)((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout()));
            DBCollection records = this.mongoServer.getDatastore().getDB().getCollection("record");
            DBCollection proxies = this.mongoServer.getDatastore().getDB().getCollection("Proxy");
            DBCollection providedCHOs = this.mongoServer.getDatastore().getDB().getCollection("ProvidedCHO");
            DBCollection aggregations = this.mongoServer.getDatastore().getDB().getCollection("Aggregation");
            DBCollection europeanaAggregations = this.mongoServer.getDatastore().getDB().getCollection("EuropeanaAggregation");
            DBCollection physicalThing = this.mongoServer.getDatastore().getDB().getCollection("PhysicalThing");
            BasicDBObject query = new BasicDBObject("about", (Object)((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout());
            BasicDBObject proxyQuery = new BasicDBObject("about", (Object)("/proxy/provider" + ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout()));
            BasicDBObject europeanaProxyQuery = new BasicDBObject("about", (Object)("/proxy/europeana" + ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout()));
            BasicDBObject providedCHOQuery = new BasicDBObject("about", (Object)("/item" + ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout()));
            BasicDBObject aggregationQuery = new BasicDBObject("about", (Object)("/aggregation/provider" + ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout()));
            BasicDBObject europeanaAggregationQuery = new BasicDBObject("about", (Object)("/aggregation/europeana" + ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout()));
            europeanaAggregations.remove((DBObject)europeanaAggregationQuery, WriteConcern.FSYNC_SAFE);
            records.remove((DBObject)query, WriteConcern.FSYNC_SAFE);
            proxies.remove((DBObject)europeanaProxyQuery, WriteConcern.FSYNC_SAFE);
            proxies.remove((DBObject)proxyQuery, WriteConcern.FSYNC_SAFE);
            physicalThing.remove((DBObject)europeanaProxyQuery, WriteConcern.FSYNC_SAFE);
            physicalThing.remove((DBObject)proxyQuery, WriteConcern.FSYNC_SAFE);
            providedCHOs.remove((DBObject)providedCHOQuery, WriteConcern.FSYNC_SAFE);
            aggregations.remove((DBObject)aggregationQuery, WriteConcern.FSYNC_SAFE);
            return true;
        }
        catch (SolrServerException e) {
            this.log.log(Level.SEVERE, e.getMessage());
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, e.getMessage());
        }
        return false;
    }

    public void clearData(String collection) {
        DBCollection records = this.mongoServer.getDatastore().getDB().getCollection("record");
        DBCollection proxies = this.mongoServer.getDatastore().getDB().getCollection("Proxy");
        DBCollection physicalThing = this.mongoServer.getDatastore().getDB().getCollection("PhysicalThing");
        DBCollection providedCHOs = this.mongoServer.getDatastore().getDB().getCollection("ProvidedCHO");
        DBCollection aggregations = this.mongoServer.getDatastore().getDB().getCollection("Aggregation");
        DBCollection europeanaAggregations = this.mongoServer.getDatastore().getDB().getCollection("EuropeanaAggregation");
        BasicDBObject query = new BasicDBObject("about", (Object)Pattern.compile("^/" + collection + "/"));
        BasicDBObject proxyQuery = new BasicDBObject("about", (Object)Pattern.compile("^/proxy/provider/" + collection + "/"));
        BasicDBObject europeanaProxyQuery = new BasicDBObject("about", (Object)Pattern.compile("^/proxy/europeana/" + collection + "/"));
        BasicDBObject providedCHOQuery = new BasicDBObject("about", (Object)Pattern.compile("^/item/" + collection + "/"));
        BasicDBObject aggregationQuery = new BasicDBObject("about", (Object)Pattern.compile("^/aggregation/provider/" + collection + "/"));
        BasicDBObject europeanaAggregationQuery = new BasicDBObject("about", (Object)Pattern.compile("^/aggregation/europeana/" + collection + "/"));
        europeanaAggregations.remove((DBObject)europeanaAggregationQuery, WriteConcern.FSYNC_SAFE);
        records.remove((DBObject)query, WriteConcern.FSYNC_SAFE);
        proxies.remove((DBObject)europeanaProxyQuery, WriteConcern.FSYNC_SAFE);
        proxies.remove((DBObject)proxyQuery, WriteConcern.FSYNC_SAFE);
        physicalThing.remove((DBObject)proxyQuery, WriteConcern.FSYNC_SAFE);
        physicalThing.remove((DBObject)europeanaProxyQuery, WriteConcern.FSYNC_SAFE);
        providedCHOs.remove((DBObject)providedCHOQuery, WriteConcern.FSYNC_SAFE);
        aggregations.remove((DBObject)aggregationQuery, WriteConcern.FSYNC_SAFE);
    }

    public void saveEdmClasses(FullBeanImpl fullBean, boolean isFirstSave) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<AgentImpl> agents = new ArrayList<AgentImpl>();
        ArrayList<ConceptImpl> concepts = new ArrayList<ConceptImpl>();
        ArrayList<TimespanImpl> timespans = new ArrayList<TimespanImpl>();
        ArrayList<PlaceImpl> places = new ArrayList<PlaceImpl>();
        ArrayList<LicenseImpl> licenses = new ArrayList<LicenseImpl>();
        if (fullBean.getAgents() != null) {
            for (AgentImpl agent : fullBean.getAgents()) {
                AgentImpl retAgent = this.mongoServer.searchByAbout(AgentImpl.class, agent.getAbout());
                if (retAgent != null) {
                    agents.add(new AgentUpdater().update(retAgent, agent, (MongoServer)this.mongoServer));
                    continue;
                }
                try {
                    this.mongoServer.getDatastore().save((Object)agent);
                    agents.add(agent);
                }
                catch (Exception e) {
                    agents.add(new AgentUpdater().update(this.mongoServer.searchByAbout(AgentImpl.class, agent.getAbout()), agent, (MongoServer)this.mongoServer));
                }
            }
        }
        if (fullBean.getPlaces() != null) {
            for (PlaceImpl place : fullBean.getPlaces()) {
                PlaceImpl retPlace = this.mongoServer.searchByAbout(PlaceImpl.class, place.getAbout());
                if (retPlace != null) {
                    places.add(new PlaceUpdater().update(retPlace, place, (MongoServer)this.mongoServer));
                    continue;
                }
                try {
                    this.mongoServer.getDatastore().save((Object)place);
                    places.add(place);
                }
                catch (Exception e) {
                    places.add(new PlaceUpdater().update(this.mongoServer.searchByAbout(PlaceImpl.class, place.getAbout()), place, (MongoServer)this.mongoServer));
                }
            }
        }
        if (fullBean.getConcepts() != null) {
            for (ConceptImpl concept : fullBean.getConcepts()) {
                ConceptImpl retConcept = this.mongoServer.searchByAbout(ConceptImpl.class, concept.getAbout());
                if (retConcept != null) {
                    concepts.add(new ConceptUpdater().update(retConcept, concept, (MongoServer)this.mongoServer));
                    continue;
                }
                try {
                    this.mongoServer.getDatastore().save((Object)concept);
                    concepts.add(concept);
                }
                catch (Exception e) {
                    concepts.add(new ConceptUpdater().update(this.mongoServer.searchByAbout(ConceptImpl.class, concept.getAbout()), concept, (MongoServer)this.mongoServer));
                }
            }
        }
        if (fullBean.getTimespans() != null) {
            for (TimespanImpl timespan : fullBean.getTimespans()) {
                TimespanImpl retTimespan = this.mongoServer.searchByAbout(TimespanImpl.class, timespan.getAbout());
                if (retTimespan != null) {
                    timespans.add(new TimespanUpdater().update(retTimespan, timespan, (MongoServer)this.mongoServer));
                    continue;
                }
                try {
                    this.mongoServer.getDatastore().save((Object)timespan);
                    timespans.add(timespan);
                }
                catch (Exception e) {
                    timespans.add(new TimespanUpdater().update(this.mongoServer.searchByAbout(TimespanImpl.class, timespan.getAbout()), timespan, (MongoServer)this.mongoServer));
                }
            }
        }
        if (fullBean.getLicenses() != null) {
            for (LicenseImpl license : fullBean.getLicenses()) {
                LicenseImpl retLicense = this.mongoServer.searchByAbout(LicenseImpl.class, license.getAbout());
                if (retLicense != null) {
                    licenses.add(new LicenseUpdater().update(retLicense, license, (MongoServer)this.mongoServer));
                    continue;
                }
                try {
                    this.mongoServer.getDatastore().save((Object)license);
                    licenses.add(license);
                }
                catch (Exception e) {
                    licenses.add(new LicenseUpdater().update(this.mongoServer.searchByAbout(LicenseImpl.class, license.getAbout()), license, (MongoServer)this.mongoServer));
                }
            }
        }
        if (isFirstSave) {
            this.mongoServer.getDatastore().save(fullBean.getProvidedCHOs());
            this.mongoServer.getDatastore().save((Object)fullBean.getEuropeanaAggregation());
            this.mongoServer.getDatastore().save(fullBean.getProxies());
            this.mongoServer.getDatastore().save(fullBean.getAggregations());
            if (fullBean.getEuropeanaAggregation().getWebResources() != null) {
                this.mongoServer.getDatastore().save((Iterable)fullBean.getEuropeanaAggregation().getWebResources());
            }
            for (AggregationImpl aggr : fullBean.getAggregations()) {
                if (aggr.getWebResources() == null) continue;
                this.mongoServer.getDatastore().save(aggr.getWebResources());
            }
        } else {
            ArrayList<ProvidedCHOImpl> pChos = new ArrayList<ProvidedCHOImpl>();
            ArrayList<ProxyImpl> proxies = new ArrayList<ProxyImpl>();
            ArrayList<AggregationImpl> aggregations = new ArrayList<AggregationImpl>();
            for (ProvidedCHOImpl pCho : fullBean.getProvidedCHOs()) {
                pChos.add(new ProvidedChoUpdater().update(this.mongoServer.searchByAbout(ProvidedCHOImpl.class, pCho.getAbout()), pCho, (MongoServer)this.mongoServer));
            }
            for (AggregationImpl aggr : fullBean.getAggregations()) {
                aggregations.add(new AggregationUpdater().update(this.mongoServer.searchByAbout(AggregationImpl.class, aggr.getAbout()), aggr, (MongoServer)this.mongoServer));
            }
            fullBean.setEuropeanaAggregation(new EuropeanaAggregationUpdater().update(this.mongoServer.searchByAbout(EuropeanaAggregationImpl.class, fullBean.getEuropeanaAggregation().getAbout()), (EuropeanaAggregationImpl)fullBean.getEuropeanaAggregation(), (MongoServer)this.mongoServer));
            for (ProxyImpl prx : fullBean.getProxies()) {
                proxies.add(new ProxyUpdater().update(this.mongoServer.searchByAbout(ProxyImpl.class, prx.getAbout()), prx, (MongoServer)this.mongoServer));
            }
            fullBean.setProvidedCHOs(pChos);
            fullBean.setAggregations(aggregations);
            fullBean.setProxies(proxies);
        }
        fullBean.setAgents(agents);
        fullBean.setPlaces(places);
        fullBean.setConcepts(concepts);
        fullBean.setTimespans(timespans);
        fullBean.setLicenses(licenses);
    }

    public FullBeanImpl updateFullBean(FullBeanImpl fullBean) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.saveEdmClasses(fullBean, false);
        Query updateQuery = (Query)this.mongoServer.getDatastore().createQuery(FullBeanImpl.class).field("about").equal((Object)fullBean.getAbout().replace("/item", ""));
        UpdateOperations ops = this.mongoServer.getDatastore().createUpdateOperations(FullBeanImpl.class);
        ops.set("title", (Object)(fullBean.getTitle() != null ? fullBean.getTitle() : new String[]{}));
        ops.set("year", (Object)(fullBean.getYear() != null ? fullBean.getYear() : new String[]{}));
        ops.set("provider", (Object)(fullBean.getProvider() != null ? fullBean.getProvider() : new String[]{}));
        ops.set("language", (Object)(fullBean.getLanguage() != null ? fullBean.getLanguage() : new String[]{}));
        ops.set("type", (Object)(fullBean.getType() != null ? fullBean.getType() : DocType.IMAGE));
        ops.set("europeanaCompleteness", (Object)fullBean.getEuropeanaCompleteness());
        ops.set("optOut", (Object)fullBean.isOptedOut());
        ops.set("places", fullBean.getPlaces() != null ? fullBean.getPlaces() : new ArrayList());
        ops.set("agents", fullBean.getAgents() != null ? fullBean.getAgents() : new ArrayList());
        ops.set("timespans", fullBean.getTimespans() != null ? fullBean.getTimespans() : new ArrayList());
        ops.set("concepts", fullBean.getConcepts() != null ? fullBean.getConcepts() : new ArrayList());
        ops.set("aggregations", fullBean.getAggregations());
        ops.set("providedCHOs", fullBean.getProvidedCHOs());
        ops.set("europeanaAggregation", (Object)fullBean.getEuropeanaAggregation());
        ops.set("proxies", fullBean.getProxies());
        ops.set("country", (Object)(fullBean.getCountry() != null ? fullBean.getCountry() : new String[]{}));
        ops.set("europeanaCollectionName", (Object)fullBean.getEuropeanaCollectionName());
        this.mongoServer.getDatastore().update(updateQuery, ops);
        try {
            return (FullBeanImpl)this.mongoServer.getFullBean(fullBean.getAbout());
        }
        catch (MongoDBException e) {
            this.log.log(Level.SEVERE, e.getMessage());
            return fullBean;
        }
    }

    public List<IDocument> getDocumentsByStatesUsingBatch(List<State> stateVlues, Map<String, List<String>> queryChoices, int batchSize) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IDocument getDocumentById(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void insertDocument(IDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateDocumentUsingId(IDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cloneDocument(IDocument originalDocument, IDocument clonedDocument) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteDocument(IDocument id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void commit() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

