/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils.construct;

import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import eu.europeana.corelib.definitions.solr.entity.WebResource;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.EuropeanaAggregationImpl;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.construct.Updater;
import eu.europeana.corelib.solr.utils.construct.WebResourceCreator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class EuropeanaAggregationUpdater
implements Updater<EuropeanaAggregationImpl> {
    private static final String PORTAL_PREFIX = "http://europeana.eu/portal/record/";
    private static final String PORTAL_SUFFIX = ".html";

    @Override
    public EuropeanaAggregationImpl update(EuropeanaAggregationImpl mongoEntity, EuropeanaAggregationImpl newEntity, MongoServer mongoServer) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Query updateQuery = (Query)mongoServer.getDatastore().createQuery(EuropeanaAggregationImpl.class).field("about").equal((Object)mongoEntity.getAbout());
        UpdateOperations ops = mongoServer.getDatastore().createUpdateOperations(EuropeanaAggregationImpl.class);
        boolean update = false;
        update = MongoUtils.updateString(mongoEntity, newEntity, "aggregatedCHO", ops) || update;
        update = MongoUtils.updateString(mongoEntity, newEntity, "edmIsShownBy", ops) || update;
        update = MongoUtils.updateMap(mongoEntity, newEntity, "edmRights", ops) || update;
        update = MongoUtils.updateMap(mongoEntity, newEntity, "edmCountry", ops) || update;
        String landingPage = PORTAL_PREFIX + StringUtils.substringAfter((String)mongoEntity.getAggregatedCHO(), (String)"/item/") + PORTAL_SUFFIX;
        if (!StringUtils.equals((String)mongoEntity.getEdmLandingPage(), (String)landingPage)) {
            mongoEntity.setEdmLandingPage(landingPage);
            ops.set("edmLandingPage", (Object)landingPage);
        }
        update = MongoUtils.updateMap(mongoEntity, newEntity, "edmLanguage", ops) || update;
        update = MongoUtils.updateMap(mongoEntity, newEntity, "dcCreator", ops) || update;
        update = MongoUtils.updateString(mongoEntity, newEntity, "edmPreview", ops) || update;
        update = MongoUtils.updateArray(mongoEntity, newEntity, "aggregates", ops) || update;
        ArrayList<WebResource> webResources = new ArrayList<WebResource>();
        for (WebResource webResource : mongoEntity.getWebResources()) {
            webResources.add(new WebResourceCreator().saveWebResource(webResource, mongoServer));
        }
        mongoEntity.setWebResources(webResources);
        if (update) {
            mongoServer.getDatastore().update(updateQuery, ops);
        }
        return mongoEntity;
    }
}

