/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils.construct;

import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import eu.europeana.corelib.definitions.solr.entity.WebResource;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.AggregationImpl;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.construct.Updater;
import eu.europeana.corelib.solr.utils.construct.WebResourceCreator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class AggregationUpdater
implements Updater<AggregationImpl> {
    @Override
    public AggregationImpl update(AggregationImpl mongoEntity, AggregationImpl newEntity, MongoServer mongoServer) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Query updateQuery = (Query)mongoServer.getDatastore().createQuery(AggregationImpl.class).field("about").equal((Object)mongoEntity.getAbout());
        UpdateOperations ops = mongoServer.getDatastore().createUpdateOperations(AggregationImpl.class);
        boolean update = false;
        update = MongoUtils.updateString(mongoEntity, newEntity, "aggregatedCHO", ops) || update;
        update = MongoUtils.updateString(mongoEntity, newEntity, "edmIsShownAt", ops) || update;
        update = MongoUtils.updateString(mongoEntity, newEntity, "edmIsShownBy", ops) || update;
        update = MongoUtils.updateString(mongoEntity, newEntity, "edmObject", ops) || update;
        update = MongoUtils.updateString(mongoEntity, newEntity, "edmUgc", ops) || update;
        update = MongoUtils.updateMap(mongoEntity, newEntity, "edmDataProvider", ops) || update;
        update = MongoUtils.updateMap(mongoEntity, newEntity, "edmProvider", ops) || update;
        update = MongoUtils.updateMap(mongoEntity, newEntity, "dcRights", ops) || update;
        update = MongoUtils.updateMap(mongoEntity, newEntity, "edmRights", ops) || update;
        update = MongoUtils.updateArray(mongoEntity, newEntity, "hasView", ops) || update;
        boolean bl = update = MongoUtils.updateArray(mongoEntity, newEntity, "aggregates", ops) || update;
        if (newEntity.getEdmPreviewNoDistribute() != null) {
            if (mongoEntity.getEdmPreviewNoDistribute() == null || mongoEntity.getEdmPreviewNoDistribute() != newEntity.getEdmPreviewNoDistribute()) {
                ops.set("edmPreviewNoDistribute", (Object)newEntity.getEdmPreviewNoDistribute());
                mongoEntity.setEdmPreviewNoDistribute(newEntity.getEdmPreviewNoDistribute());
                update = true;
            }
        } else if (mongoEntity.getEdmPreviewNoDistribute() != null) {
            ops.unset("edmPreviewNoDistribute");
            mongoEntity.setEdmPreviewNoDistribute(null);
            update = true;
        }
        ArrayList<WebResource> webResources = new ArrayList<WebResource>();
        for (WebResource webResource : mongoEntity.getWebResources()) {
            webResources.add(new WebResourceCreator().saveWebResource(webResource, mongoServer));
        }
        mongoEntity.setWebResources(webResources);
        if (update) {
            mongoServer.getDatastore().update(updateQuery, ops);
        }
        return mongoEntity;
    }
}

