/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils;

import eu.europeana.corelib.definitions.jibx.Aggregation;
import eu.europeana.corelib.definitions.jibx.LiteralType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.ResourceOrLiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.definitions.solr.beans.ApiBean;
import eu.europeana.corelib.definitions.solr.beans.BriefBean;
import eu.europeana.corelib.definitions.solr.beans.IdBean;
import eu.europeana.corelib.definitions.solr.beans.RichBean;
import eu.europeana.corelib.definitions.solr.model.QueryTranslation;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.solr.utils.FieldMapping;
import eu.europeana.corelib.solr.utils.queryextractor.QueryExtractor;
import eu.europeana.corelib.solr.utils.queryextractor.QueryModification;
import eu.europeana.corelib.solr.utils.queryextractor.QueryNormalizer;
import eu.europeana.corelib.solr.utils.queryextractor.QueryToken;
import eu.europeana.corelib.solr.utils.queryextractor.QueryType;
import eu.europeana.corelib.utils.model.LanguageVersion;
import eu.europeana.corelib.web.service.WikipediaApiService;
import eu.europeana.corelib.web.service.impl.WikipediaApiServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;

public final class SolrUtils {
    @Resource
    private static WikipediaApiService wikipediaApiService;
    private static final Pattern ID_PATTERN;

    private SolrUtils() {
    }

    public static boolean checkTypeFacet(String[] refinements) {
        if (refinements != null) {
            for (String refinement : refinements) {
                if (!StringUtils.contains((String)refinement, (String)"TYPE:") || StringUtils.contains((String)refinement, (String)" OR ") || DocType.safeValueOf((String)StringUtils.substringAfter((String)refinement, (String)"TYPE:")) != null) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> T exists(Class<T> clazz, T object) throws InstantiationException, IllegalAccessException {
        return object == null ? clazz.newInstance() : object;
    }

    public static String[] resourceOrLiteralToArray(ResourceOrLiteralType type) {
        if (type != null) {
            ArrayList<String> lst = new ArrayList<String>();
            if (type.getResource() != null) {
                lst.add(type.getResource().getResource());
            }
            if (type.getString() != null) {
                lst.add(type.getString());
            }
            return lst.toArray(new String[lst.size()]);
        }
        return new String[0];
    }

    public static String[] resourceOrLiteralListToArray(List<? extends ResourceOrLiteralType> list) {
        if (list != null) {
            ArrayList<String> lst = new ArrayList<String>();
            for (ResourceOrLiteralType resourceOrLiteralType : list) {
                if (resourceOrLiteralType.getResource() != null) {
                    lst.add(resourceOrLiteralType.getResource().getResource());
                }
                if (resourceOrLiteralType.getString() == null) continue;
                lst.add(resourceOrLiteralType.getString());
            }
            String[] arr = lst.toArray(new String[lst.size()]);
            return arr;
        }
        return new String[0];
    }

    public static String[] literalListToArray(List<? extends LiteralType> list) {
        if (list != null) {
            String[] arr = new String[list.size()];
            int i = 0;
            for (LiteralType literalType : list) {
                arr[i] = literalType.getString();
                ++i;
            }
            return arr;
        }
        return new String[0];
    }

    public static String[] resourceListToArray(List<? extends ResourceType> list) {
        if (list != null) {
            String[] arr = new String[list.size()];
            int i = 0;
            for (ResourceType resourceType : list) {
                arr[i] = resourceType.getResource();
                ++i;
            }
            return arr;
        }
        return new String[0];
    }

    public static String getLiteralString(LiteralType obj) {
        if (obj != null) {
            return obj.getString() != null ? obj.getString() : null;
        }
        return null;
    }

    public static String getResourceOrLiteralString(ResourceOrLiteralType obj) {
        if (obj != null) {
            return obj.getResource() != null ? obj.getResource().getResource() : obj.getString();
        }
        return null;
    }

    public static String getResourceString(ResourceType obj) {
        if (obj != null) {
            return obj.getResource() != null ? obj.getResource() : null;
        }
        return null;
    }

    public static Class<? extends IdBeanImpl> getImplementationClass(Class<? extends IdBean> interfaze) {
        if (interfaze != null) {
            if (interfaze == RichBean.class) {
                return RichBeanImpl.class;
            }
            if (interfaze == ApiBean.class) {
                return ApiBeanImpl.class;
            }
            if (interfaze == BriefBean.class) {
                return BriefBeanImpl.class;
            }
            if (interfaze == IdBean.class) {
                return IdBeanImpl.class;
            }
        }
        return null;
    }

    public static <T extends LiteralType> SolrInputDocument addFieldFromLiteral(SolrInputDocument solrInputDocument, T obj, EdmLabel label) {
        if (obj != null && obj.getString() != null) {
            if (obj.getLang() != null) {
                solrInputDocument.addField(label.toString() + "." + obj.getLang().getLang(), (Object)obj.getString());
            } else {
                solrInputDocument.addField(label.toString(), (Object)obj.getString());
            }
        }
        return solrInputDocument;
    }

    public static <T extends ResourceType> SolrInputDocument addFieldFromResource(SolrInputDocument solrInputDocument, T obj, EdmLabel label) {
        if (obj != null && obj.getResource() != null) {
            solrInputDocument.addField(label.toString(), (Object)obj.getResource());
        }
        return solrInputDocument;
    }

    public static SolrInputDocument addFieldFromEnum(SolrInputDocument solrInputDocument, String obj, EdmLabel label) {
        if (obj != null) {
            solrInputDocument.addField(label.toString(), (Object)StringUtils.lowerCase((String)obj));
        }
        return solrInputDocument;
    }

    public static <T extends ResourceOrLiteralType> SolrInputDocument addFieldFromResourceOrLiteral(SolrInputDocument solrInputDocument, T obj, EdmLabel label) {
        if (obj != null) {
            if (obj.getResource() != null) {
                solrInputDocument.addField(label.toString(), (Object)StringUtils.trim((String)obj.getResource().getResource()));
            }
            if (obj.getString() != null) {
                if (obj.getLang() != null) {
                    solrInputDocument.addField(label.toString() + "." + obj.getLang().getLang(), (Object)StringUtils.trim((String)obj.getString()));
                } else {
                    solrInputDocument.addField(label.toString(), (Object)StringUtils.trim((String)obj.getString()));
                }
            }
        }
        return solrInputDocument;
    }

    public static String getPreviewUrl(RDF rdf) {
        if (((Aggregation)rdf.getAggregationList().get(0)).getObject() != null && StringUtils.isNotEmpty((String)((Aggregation)rdf.getAggregationList().get(0)).getObject().getResource())) {
            return ((Aggregation)rdf.getAggregationList().get(0)).getObject().getResource();
        }
        if (((Aggregation)rdf.getAggregationList().get(0)).getIsShownBy() != null && StringUtils.isNotEmpty((String)((Aggregation)rdf.getAggregationList().get(0)).getIsShownBy().getResource())) {
            return ((Aggregation)rdf.getAggregationList().get(0)).getIsShownBy().getResource();
        }
        return null;
    }

    public static String rewriteQueryFields(String query) {
        if (!query.contains(":")) {
            return query;
        }
        if (query.equals("title:*:*")) {
            return "title:*";
        }
        if (query.equals("who:*:*")) {
            return "who:*";
        }
        if (query.equals("what:*:*")) {
            return "what:*";
        }
        if (query.equals("where:*:*")) {
            return "where:*";
        }
        if (query.equals("when:*:*")) {
            return "when:*";
        }
        for (FieldMapping field : FieldMapping.values()) {
            if (!query.contains(field.getEseField() + ":")) continue;
            query = query.replaceAll("\\b" + field.getEseField() + ":", field.getEdmField() + ":");
        }
        return query;
    }

    public static String escapeQuery(String query) {
        return ClientUtils.escapeQueryChars((String)query).replace("\\ ", " ").replace("\\-", "-");
    }

    public static String escapeFacet(String field, String query) {
        if (StringUtils.isNotBlank((String)field) && StringUtils.isNotBlank((String)query)) {
            query = SolrUtils.escapeQuery(StringUtils.trim((String)query));
            StringBuilder sb = new StringBuilder(StringUtils.trim((String)field));
            sb.append(":\"");
            sb.append(query);
            sb.append("\"");
            return sb.toString();
        }
        return null;
    }

    public static List<FacetField> extractQueryFacets(Map<String, Integer> queryFacets) {
        HashMap<String, FacetField> map = new HashMap<String, FacetField>();
        for (String query : queryFacets.keySet()) {
            Matcher matcher = ID_PATTERN.matcher(query);
            if (!matcher.find()) continue;
            String field = matcher.group(1);
            String value = matcher.group(2);
            if (!map.containsKey(field)) {
                map.put(field, new FacetField(field));
            }
            ((FacetField)map.get(field)).add(value, (long)queryFacets.get(query).intValue());
        }
        ArrayList<FacetField> list = new ArrayList<FacetField>(map.values());
        return list;
    }

    public static QueryTranslation translateQuery(String query, List<String> languages) {
        QueryTranslation queryTranslation = new QueryTranslation();
        if (wikipediaApiService == null) {
            wikipediaApiService = WikipediaApiServiceImpl.getBeanInstance();
        }
        QueryExtractor queryExtractor = new QueryExtractor(query);
        String modifiedQuery = new String(query);
        List<QueryToken> queryTokens = queryExtractor.extractInfo(true);
        ArrayList<QueryModification> queryModifications = new ArrayList<QueryModification>();
        for (QueryToken token : queryTokens) {
            QueryModification queryModification;
            List languageVersions;
            if (token.getType().equals((Object)QueryType.TERMRANGE) || (languageVersions = wikipediaApiService.getVersionsInMultiLanguage(token.getTerm(), languages)).size() <= 0) continue;
            queryTranslation.addLanguageVersions(token.getExtendedPosition(), languageVersions);
            List<String> alternatives = SolrUtils.extractLanguageVersions(languageVersions);
            if (alternatives.size() <= 0 || (queryModification = token.createModification(modifiedQuery, alternatives)) == null) continue;
            queryModifications.add(queryModification);
        }
        queryTranslation.sortLanguageVersions();
        queryTranslation.setModifiedQuery(queryExtractor.rewrite(queryModifications));
        return queryTranslation;
    }

    private static List<String> extractLanguageVersions(List<LanguageVersion> languageVersions) {
        ArrayList<String> termsList = new ArrayList<String>();
        HashSet<String> terms = new HashSet<String>();
        for (LanguageVersion languageVersion : languageVersions) {
            String text = languageVersion.getText();
            if (!StringUtils.isNotBlank((String)text)) continue;
            terms.add(languageVersion.getText());
        }
        termsList.addAll(terms);
        return termsList;
    }

    public static boolean isSimpleQuery(String queryTerm) {
        return SolrUtils.isNotFieldQuery(queryTerm) && (SolrUtils.isTermQuery(queryTerm) || SolrUtils.containsNoneSearchOperators(queryTerm));
    }

    public static boolean isTermQuery(String queryTerm) {
        StandardQueryParser queryParserHelper = new StandardQueryParser();
        Query query = null;
        try {
            query = queryParserHelper.parse(queryTerm, "text");
        }
        catch (QueryNodeException e) {
            e.printStackTrace();
        }
        return query != null && query instanceof TermQuery;
    }

    private static boolean containsNoneSearchOperators(String queryTerm) {
        return !StringUtils.contains((String)queryTerm, (String)" AND ") && !StringUtils.contains((String)queryTerm, (String)" NOT ") && !StringUtils.contains((String)queryTerm, (String)" OR ") && !StringUtils.contains((String)queryTerm, (String)"*");
    }

    private static boolean isNotFieldQuery(String queryTerm) {
        return !StringUtils.contains((String)queryTerm, (String)":");
    }

    public static SolrInputDocument addFromMap(SolrInputDocument doc, EdmLabel edmLabel, Map<String, List<String>> val) {
        if (val != null) {
            for (String key : val.keySet()) {
                ArrayList values = doc.getFieldValues(edmLabel.toString() + "." + key);
                if (values == null) {
                    values = new ArrayList();
                }
                values.addAll(val.get(key));
                doc.setField(edmLabel.toString() + "." + key, values);
            }
        }
        return doc;
    }

    public static SolrInputDocument addFromStringArray(SolrInputDocument doc, EdmLabel edmLabel, String[] val) {
        if (val != null) {
            ArrayList<String> values = doc.getFieldValues(edmLabel.toString());
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.addAll(Arrays.asList(val));
            doc.setField(edmLabel.toString(), values);
        }
        return doc;
    }

    public static SolrInputDocument addFromString(SolrInputDocument doc, EdmLabel edmLabel, String val) {
        if (val != null) {
            ArrayList<String> values = doc.getFieldValues(edmLabel.toString());
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(val);
            doc.setField(edmLabel.toString(), values);
        }
        return doc;
    }

    public static String normalizeBooleans(String query) {
        return QueryNormalizer.normalizeBooleans(query);
    }

    public static void translateQuery(String rawQueryString, QueryTranslation translatedQueries) {
        Map languageVersionMap = translatedQueries.getSortedMap();
        int lastPart = 0;
        String rewritten = "";
        for (String key : languageVersionMap.keySet()) {
            String[] parts = key.split(":", 2);
            int start = Integer.parseInt(parts[0]);
            int end = Integer.parseInt(parts[1]);
            rewritten = rewritten + rawQueryString.substring(lastPart, start);
            String query = rawQueryString.substring(start, end);
            lastPart = end;
            List<String> languageVersions = SolrUtils.extractLanguageVersions((List)languageVersionMap.get(key));
            if (languageVersions == null || languageVersions.size() <= 0) continue;
            if (!(query.startsWith("\"") && query.endsWith("\"") && query.contains(" "))) {
                query = "(" + query + ")";
            }
            String modification = "(" + query + " OR \"" + StringUtils.join(languageVersions, (String)"\" OR \"") + "\"" + ")";
            rewritten = rewritten + modification;
        }
        if (lastPart < rawQueryString.length()) {
            rewritten = rewritten + rawQueryString.substring(lastPart);
        }
        translatedQueries.setModifiedQuery(rewritten);
    }

    static {
        ID_PATTERN = Pattern.compile("^\\{!id=([^:]+):([^:]+) ex=(.*?)\\}");
    }
}

