/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils;

import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import eu.europeana.corelib.definitions.jibx.LiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceOrLiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public final class MongoUtils {
    public static boolean contains(String[] str1, String str2) {
        if (str1 != null) {
            for (String str : str1) {
                if (!StringUtils.equals((String)str, (String)str2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Map<String, List<String>> map, String key, String val) {
        if (map.keySet().contains(key)) {
            for (String str : map.get(key)) {
                if (!StringUtils.equals((String)str, (String)val)) continue;
                return true;
            }
        }
        return false;
    }

    public static void delete(Class<?> clazz, String about, EdmMongoServer mongoServer) {
        mongoServer.getDatastore().delete(mongoServer.getDatastore().createQuery(clazz).filter("about", (Object)about));
    }

    public static <T> void update(Class<T> clazz, String about, MongoServer mongoServer, String field, Object value) {
        if (value != null) {
            Query updateQuery = (Query)mongoServer.getDatastore().createQuery(clazz).field("about").equal((Object)about);
            UpdateOperations ops = null;
            ops = value instanceof List && !StringUtils.equals((String)"webResources", (String)field) ? mongoServer.getDatastore().createUpdateOperations(clazz).set(field, (Object)((List)value).toArray(new String[((List)value).size()])) : mongoServer.getDatastore().createUpdateOperations(clazz).set(field, value);
            mongoServer.getDatastore().update(updateQuery, ops);
        }
    }

    public static <T extends LiteralType> Map<String, List<String>> createLiteralMapFromString(T obj) {
        HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
        if (obj != null) {
            if (obj.getLang() != null && StringUtils.isNotBlank((String)obj.getLang().getLang())) {
                ArrayList<String> val = new ArrayList<String>();
                val.add(obj.getString());
                retMap.put(obj.getLang().getLang(), val);
            } else {
                ArrayList<String> val = new ArrayList<String>();
                val.add(obj.getString());
                retMap.put("def", val);
            }
            return retMap;
        }
        return null;
    }

    public static Map<String, List<String>> createLiteralMapFromString(String obj) {
        HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
        if (obj != null) {
            ArrayList<String> val = new ArrayList<String>();
            val.add(obj);
            retMap.put("def", val);
            return retMap;
        }
        return null;
    }

    public static boolean mapEquals(Map<String, List<String>> mapA, Map<String, List<String>> mapB) {
        if (mapA != null && mapB != null && mapA.keySet().equals(mapB.keySet())) {
            boolean equals = true;
            for (String keyA : mapA.keySet()) {
                List<String> listA = mapA.get(keyA);
                List<String> listB = mapB.get(keyA);
                if (listA == null || listB == null) continue;
                Collections.sort(listA);
                Collections.sort(listB);
                equals &= listA.equals(listB);
            }
            return equals;
        }
        return false;
    }

    public static boolean mapRefEquals(Map<String, String> mapA, Map<String, String> mapB) {
        if (mapA != null && mapB != null && mapA.keySet().equals(mapB.keySet())) {
            boolean equals = true;
            Iterator<String> i$ = mapA.keySet().iterator();
            if (i$.hasNext()) {
                String keyA = i$.next();
                String strA = mapA.get(keyA);
                String strB = mapB.get(keyA);
                return StringUtils.equals((String)strA, (String)strB);
            }
        }
        return false;
    }

    public static boolean arrayEquals(String[] arrA, String[] arrB) {
        if (arrA.length == arrB.length) {
            ArrayList<String> listA = new ArrayList<String>(Arrays.asList(arrA));
            ArrayList<String> listB = new ArrayList<String>(Arrays.asList(arrB));
            Collections.sort(listA);
            Collections.sort(listB);
            return listA.equals(listB);
        }
        return false;
    }

    public static <T extends ResourceOrLiteralType> Map<String, List<String>> createResourceOrLiteralMapFromString(T obj) {
        HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
        if (obj != null) {
            if (obj.getLang() != null && StringUtils.isNotEmpty((String)obj.getLang().getLang())) {
                ArrayList<String> val;
                if (obj.getString() != null && StringUtils.trimToNull((String)obj.getString()) != null) {
                    val = new ArrayList<String>();
                    val.add(StringUtils.trim((String)obj.getString()));
                    retMap.put(obj.getLang().getLang(), val);
                }
                if (obj.getResource() != null) {
                    val = retMap.get(obj.getLang().getLang()) != null ? (List)retMap.get(obj.getLang().getLang()) : new ArrayList();
                    val.add(obj.getResource().getResource());
                    retMap.put(obj.getLang().getLang(), val);
                }
            } else {
                List<String> val;
                if (StringUtils.isNotBlank((String)StringUtils.trimToNull((String)obj.getString()))) {
                    val = retMap.get("def") != null ? (List)retMap.get("def") : new ArrayList();
                    val.add(obj.getString());
                    retMap.put("def", val);
                }
                if (obj.getResource() != null && StringUtils.isNotBlank((String)StringUtils.trimToNull((String)obj.getResource().getResource()))) {
                    val = retMap.get("def") != null ? (List)retMap.get("def") : new ArrayList();
                    val.add(StringUtils.trim((String)obj.getResource().getResource()));
                    retMap.put("def", val);
                }
            }
            return retMap;
        }
        return null;
    }

    public static <T extends ResourceOrLiteralType> Map<String, String> createResourceOrLiteralRefFromString(T obj) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (obj != null) {
            if (obj.getLang() != null && StringUtils.isNotEmpty((String)obj.getLang().getLang())) {
                String val;
                if (obj.getString() != null && StringUtils.trimToNull((String)obj.getString()) != null) {
                    val = StringUtils.trim((String)obj.getString());
                    retMap.put(obj.getLang().getLang(), val);
                }
                if (obj.getResource() != null) {
                    val = obj.getResource().getResource();
                    retMap.put(obj.getLang().getLang(), val);
                }
            } else {
                String val;
                if (obj.getString() != null && StringUtils.trimToNull((String)obj.getString()) != null) {
                    val = StringUtils.trim((String)obj.getString());
                    retMap.put("def", val);
                }
                if (obj.getResource() != null) {
                    val = obj.getResource().getResource();
                    retMap.put("def", val);
                }
            }
            return retMap;
        }
        return null;
    }

    public static <T extends ResourceType> Map<String, List<String>> createResourceMapFromString(T obj) {
        HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
        if (obj != null) {
            if (StringUtils.isNotBlank((String)StringUtils.trimToNull((String)obj.getResource()))) {
                List<String> val = retMap.get("def") != null ? (List)retMap.get("def") : new ArrayList();
                val.add(obj.getResource());
                retMap.put("def", val);
            }
            return retMap;
        }
        return null;
    }

    public static <T extends LiteralType> Map<String, List<String>> createLiteralMapFromList(List<T> list) {
        if (list != null && list.size() > 0) {
            HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
            for (LiteralType obj : list) {
                if (obj.getLang() != null && StringUtils.isNotBlank((String)obj.getLang().getLang())) {
                    String lang = obj.getLang().getLang();
                    ArrayList<String> val = (ArrayList<String>)retMap.get(lang);
                    if (val == null) {
                        val = new ArrayList<String>();
                    }
                    val.add(StringUtils.trim((String)obj.getString()));
                    retMap.put(lang, val);
                    continue;
                }
                ArrayList<String> val = (ArrayList<String>)retMap.get("def");
                if (val == null) {
                    val = new ArrayList<String>();
                }
                val.add(obj.getString());
                retMap.put("def", val);
            }
            return retMap;
        }
        return null;
    }

    public static <T extends ResourceType> Map<String, List<String>> createResourceMapFromList(List<T> list) {
        if (list != null && list.size() > 0) {
            HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
            for (ResourceType obj : list) {
                ArrayList<String> val = (ArrayList<String>)retMap.get("def");
                if (val == null) {
                    val = new ArrayList<String>();
                }
                val.add(StringUtils.trim((String)obj.getResource()));
                retMap.put("def", val);
            }
            return retMap;
        }
        return null;
    }

    public static <T extends ResourceOrLiteralType> Map<String, List<String>> createResourceOrLiteralMapFromList(List<T> list) {
        if (list != null && list.size() > 0) {
            HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
            for (ResourceOrLiteralType obj : list) {
                List<String> val;
                if (obj.getString() != null && StringUtils.isNotBlank((String)obj.getString())) {
                    if (obj.getLang() != null && StringUtils.isNotBlank((String)obj.getLang().getLang())) {
                        val = (List)retMap.get(obj.getLang().getLang());
                        if (val == null) {
                            val = new ArrayList();
                        }
                        val.add(obj.getString());
                        retMap.put(obj.getLang().getLang(), val);
                    } else {
                        val = (ArrayList<String>)retMap.get("def");
                        if (val == null) {
                            val = new ArrayList<String>();
                        }
                        val.add(obj.getString());
                        retMap.put("def", val);
                    }
                }
                if (obj.getResource() == null || !StringUtils.isNotBlank((String)obj.getResource().getResource())) continue;
                if (obj.getLang() != null) {
                    String lang = obj.getLang().getLang();
                    List val2 = retMap.containsKey(lang) ? (List)retMap.get(lang) : new ArrayList();
                    val2.add(StringUtils.trim((String)obj.getResource().getResource()));
                    retMap.put(lang, val2);
                    continue;
                }
                val = (List)retMap.get("def");
                if (val == null) {
                    val = new ArrayList();
                }
                val.add(StringUtils.trim((String)obj.getResource().getResource()));
                retMap.put("def", val);
            }
            if (retMap.size() > 0) {
                return retMap;
            }
        }
        return null;
    }

    public static <T> boolean updateMapRef(T saved, T updated, String updateField, UpdateOperations ops) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method getter = saved.getClass().getMethod("get" + StringUtils.capitalize((String)updateField), new Class[0]);
            Method setter = saved.getClass().getMethod("set" + StringUtils.capitalize((String)updateField), Map.class);
            Map savedValues = (Map)getter.invoke(saved, new Object[0]);
            Map updatedValues = (Map)getter.invoke(updated, new Object[0]);
            if (updatedValues != null) {
                if (savedValues == null || !MongoUtils.mapRefEquals(updatedValues, savedValues)) {
                    ops.set(updateField, (Object)updatedValues);
                    setter.invoke(saved, updatedValues);
                    return true;
                }
            } else if (saved != null) {
                ops.unset(updateField);
                setter.invoke(saved, new Object[]{null});
                return true;
            }
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (SecurityException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        return false;
    }

    public static <T> boolean updateMap(T saved, T updated, String updateField, UpdateOperations ops) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method getter = saved.getClass().getMethod("get" + StringUtils.capitalize((String)updateField), new Class[0]);
            Method setter = saved.getClass().getMethod("set" + StringUtils.capitalize((String)updateField), Map.class);
            Map savedValues = (Map)getter.invoke(saved, new Object[0]);
            Map updatedValues = (Map)getter.invoke(updated, new Object[0]);
            if (updatedValues != null) {
                if (savedValues == null || !MongoUtils.mapEquals(updatedValues, savedValues)) {
                    ops.set(updateField, (Object)updatedValues);
                    setter.invoke(saved, updatedValues);
                    return true;
                }
            } else if (saved != null) {
                ops.unset(updateField);
                setter.invoke(saved, new Object[]{null});
                return true;
            }
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (SecurityException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        return false;
    }

    public static <T> boolean updateArray(T saved, T updated, String updateField, UpdateOperations ops) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method getter = saved.getClass().getMethod("get" + StringUtils.capitalize((String)updateField), new Class[0]);
            Method setter = saved.getClass().getMethod("set" + StringUtils.capitalize((String)updateField), String[].class);
            String[] savedValues = (String[])getter.invoke(saved, new Object[0]);
            String[] updatedValues = (String[])getter.invoke(updated, new Object[0]);
            if (updatedValues != null) {
                if (savedValues == null || !MongoUtils.arrayEquals(updatedValues, savedValues)) {
                    for (int i = 0; i < updatedValues.length; ++i) {
                        updatedValues[i] = updatedValues[i].trim();
                    }
                    ops.set(updateField, (Object)updatedValues);
                    setter.invoke(saved, new Object[]{updatedValues});
                    return true;
                }
            } else if (saved != null) {
                ops.unset(updateField);
                setter.invoke(saved, new Object[]{null});
                return true;
            }
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (SecurityException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        return false;
    }

    public static <T> boolean updateString(T saved, T updated, String updateField, UpdateOperations ops) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method getter = saved.getClass().getMethod("get" + StringUtils.capitalize((String)updateField), new Class[0]);
            Method setter = saved.getClass().getMethod("set" + StringUtils.capitalize((String)updateField), String.class);
            String savedValues = (String)getter.invoke(saved, new Object[0]);
            String updatedValues = (String)getter.invoke(updated, new Object[0]);
            if (updatedValues != null) {
                if (savedValues == null || !StringUtils.equals((String)updatedValues, (String)savedValues)) {
                    ops.set(updateField, (Object)updatedValues.trim());
                    setter.invoke(saved, updatedValues.trim());
                    return true;
                }
            } else if (saved != null) {
                ops.unset(updateField);
                setter.invoke(saved, new Object[]{null});
                return true;
            }
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (SecurityException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(MongoUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        return false;
    }
}

