/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils;

import eu.europeana.corelib.definitions.solr.beans.FullBean;
import eu.europeana.corelib.definitions.solr.entity.Aggregation;
import eu.europeana.corelib.definitions.solr.entity.ProvidedCHO;
import eu.europeana.corelib.definitions.solr.entity.Proxy;
import eu.europeana.corelib.solr.exceptions.EdmFieldNotFoundException;
import eu.europeana.corelib.solr.exceptions.EdmValueNotFoundException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public enum EseEdmMap {
    EUROPEANA_ISSHOWNBY("europeana_isShownBy"){

        @Override
        public String getEdmValue(FullBean bean) {
            try {
                return ((Aggregation)bean.getAggregations().get(0)).getEdmIsShownBy();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EdmValueNotFoundException("edm:isShownBy", bean.getAbout());
            }
        }
    }
    ,
    EUROPEANA_ISSHOWNAT("europeana_isShownAt"){

        @Override
        public String getEdmValue(FullBean bean) {
            try {
                return ((Aggregation)bean.getAggregations().get(0)).getEdmIsShownAt();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EdmValueNotFoundException("edm:isShownAt", bean.getAbout());
            }
        }
    }
    ,
    EUROPEANA_OBJECT("europeana_object"){

        @Override
        public String getEdmValue(FullBean bean) {
            try {
                return ((Aggregation)bean.getAggregations().get(0)).getEdmObject();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EdmValueNotFoundException("edm:object", bean.getAbout());
            }
        }
    }
    ,
    DC_IDENTIFIER("dc_identifier"){

        @Override
        public String getEdmValue(FullBean bean) {
            try {
                return (String)((List)((Proxy)bean.getProxies().get(0)).getDcIdentifier().values().iterator().next()).get(0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EdmValueNotFoundException("dc:identifier", bean.getAbout());
            }
        }
    }
    ,
    EUROPEANA_FAKE("europeana_fake"){

        @Override
        public String getEdmValue(FullBean bean) {
            try {
                return ((Aggregation)bean.getAggregations().get(0)).getAbout();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EdmValueNotFoundException("ore:Aggregation@rdf:about", bean.getAbout());
            }
        }
    }
    ,
    EUROPEANA_HASVIEW("edm_hasView"){

        @Override
        public String getEdmValue(FullBean bean) {
            try {
                return bean.getEuropeanaAggregation().getEdmHasView()[0];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EdmValueNotFoundException("edm:hasView", bean.getAbout());
            }
        }
    }
    ,
    ID_EUROPEANAURI("oai_europeana19141918_id_europeanaURI"){

        @Override
        public String getEdmValue(FullBean bean) {
            System.out.println("in 1914 1918");
            return ((Aggregation)bean.getAggregations().get(0)).getHasView()[0];
        }
    }
    ,
    EUROPEANA_IDENTIFIER("europeana_identifier"){

        @Override
        public String getEdmValue(FullBean bean) throws EdmValueNotFoundException, NullPointerException {
            return ((ProvidedCHO)bean.getProvidedCHOs().get(0)).getOwlSameAs()[0];
        }
    }
    ,
    HEADER_IDENTIFIER("header_identifier"){

        @Override
        public String getEdmValue(FullBean bean) throws EdmValueNotFoundException, NullPointerException {
            return ((ProvidedCHO)bean.getProvidedCHOs().get(0)).getOwlSameAs()[0];
        }
    };

    private String field;

    private EseEdmMap(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public static EseEdmMap getEseEdmMap(String field, String recordId) {
        for (EseEdmMap map : EseEdmMap.values()) {
            if (!StringUtils.equals((String)map.field, (String)field)) continue;
            return map;
        }
        throw new EdmFieldNotFoundException(field, recordId);
    }

    public abstract String getEdmValue(FullBean var1) throws EdmValueNotFoundException, NullPointerException;
}

